/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Color;
import ch.njol.util.Checker;
import org.bukkit.entity.Sheep;

public class SheepData
extends EntityData<Sheep> {
    private Literal<Color> colors = null;
    private int sheared = 0;
    private boolean plural;

    static {
        EntityData.register(SheepData.class, "sheep", Sheep.class, "(un|non[-])sheared [%-colors%] sheep[s]", "[%-colors%] sheep[s]", "sheared [%-colors%] sheep[s]");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.sheared = matchedPattern - 1;
        this.colors = exprs[0];
        this.plural = parseResult.expr.endsWith("s");
        return true;
    }

    @Override
    public void set(Sheep entity) {
        if (this.colors != null) {
            entity.setColor(this.colors.getSingle().getWoolColor());
        }
    }

    @Override
    public boolean match(final Sheep entity) {
        return !(this.sheared != 0 && entity.isSheared() != (this.sheared == 1) || this.colors != null && !this.colors.check(null, new Checker<Color>(){

            @Override
            public boolean check(Color c) {
                return entity.getColor() == c.getWoolColor();
            }
        }));
    }

    @Override
    public Class<Sheep> getType() {
        return Sheep.class;
    }

    @Override
    public String toString() {
        if (this.colors == null) {
            return "sheep";
        }
        return String.valueOf(this.colors.toString()) + " sheep";
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }
}

