/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;

public class EffShoot
extends Effect {
    private static final double DEFAULT_SPEED = 5.0;
    private Expression<EntityData<?>> types;
    private Expression<LivingEntity> shooters;
    private Expression<Double> velocity;

    static {
        Skript.registerEffect(EffShoot.class, "shoot %entitydatas% [from %livingentity%] [(at|with) (speed|velocity) %-double%]", "(make|let) %livingentity% shoot %entitydatas% [(at|with) (speed|velocity) %-double%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.types = exprs[matchedPattern];
        this.shooters = exprs[1 - matchedPattern];
        this.velocity = exprs[2];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Double v = this.velocity == null ? 5.0 : this.velocity.getSingle(e);
        if (v == null) {
            return;
        }
        LivingEntity[] livingEntityArray = this.shooters.getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity shooter = livingEntityArray[n2];
            EntityData<?>[] entityDataArray = this.types.getArray(e);
            int n3 = entityDataArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Projectile projectile;
                EntityData<?> d = entityDataArray[n4];
                if (Fireball.class.isAssignableFrom(d.getType())) {
                    projectile = (Fireball)shooter.getWorld().spawn(shooter.getEyeLocation().add(shooter.getLocation().getDirection().multiply(0.5)), d.getType());
                    projectile.setShooter(shooter);
                    projectile.setVelocity(shooter.getLocation().getDirection().multiply(v.doubleValue()));
                } else if (Projectile.class.isAssignableFrom(d.getType())) {
                    projectile = shooter.launchProjectile(d.getType());
                    EffShoot.set((Entity)projectile, d);
                    if (this.velocity != null) {
                        projectile.setVelocity(projectile.getVelocity().normalize().multiply(v.doubleValue()));
                    }
                } else {
                    Location loc = shooter.getLocation();
                    loc.setY(loc.getY() + shooter.getEyeHeight() / 2.0);
                    Object projectile2 = d.spawn(loc);
                    if (projectile2 != null) {
                        projectile2.setVelocity(shooter.getLocation().getDirection().multiply(v.doubleValue()));
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static final <E extends Entity> void set(Entity e, EntityData<E> d) {
        d.set(e);
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "shoot " + this.types.toString(e, debug) + " from " + this.shooters.toString(e, debug);
    }
}

