/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EffPoison
extends Effect {
    private static final int DEFAULT_DURATION = 300;
    private Expression<LivingEntity> entites;
    private Expression<Timespan> duration;
    private boolean cure;

    static {
        Skript.registerEffect(EffPoison.class, "poison %livingentities% [for %-timespan%]", "(cure|unpoison) %livingentities% [from poison]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.entites = exprs[0];
        if (matchedPattern == 0) {
            this.duration = exprs[1];
        }
        this.cure = matchedPattern == 1;
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "poison " + this.entites.toString(e, debug);
    }

    @Override
    protected void execute(Event e) {
        LivingEntity[] livingEntityArray = this.entites.getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity le = livingEntityArray[n2];
            if (!this.cure) {
                int d;
                int n3 = d = this.duration == null || this.duration.getSingle(e) == null ? 300 : this.duration.getSingle(e).getTicks();
                if (le.hasPotionEffect(PotionEffectType.POISON)) {
                    for (PotionEffect pe : le.getActivePotionEffects()) {
                        if (pe.getType() != PotionEffectType.POISON) continue;
                        d += pe.getDuration();
                    }
                }
                le.addPotionEffect(new PotionEffect(PotionEffectType.POISON, d, 0), true);
            } else {
                le.removePotionEffect(PotionEffectType.POISON);
            }
            ++n2;
        }
    }
}

