/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Offset;
import org.bukkit.Location;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class EffDrop
extends Effect {
    private Expression<Integer> xp = null;
    private Expression<ItemType> items = null;
    private Expression<Offset> offsets;
    private Expression<Location> locations;

    static {
        Skript.registerEffect(EffDrop.class, "drop %integer% ([e]xp|experience) [orb[s]] [%offsets% %locations%]", "drop %itemtypes% [%offsets% %locations%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        if (matchedPattern == 0) {
            this.xp = vars[0];
        } else {
            this.items = vars[0];
        }
        this.offsets = vars[1];
        this.locations = vars[2];
        return true;
    }

    @Override
    public void execute(Event e) {
        ItemType[] types;
        ItemType[] itemTypeArray = types = this.items == null ? null : this.items.getArray(e);
        if (this.locations.isDefault() && e instanceof EntityDeathEvent && !Delay.isDelayed(e)) {
            if (this.xp != null) {
                Integer exp = this.xp.getSingle(e);
                if (exp != null) {
                    ((EntityDeathEvent)e).setDroppedExp(((EntityDeathEvent)e).getDroppedExp() + exp);
                }
                return;
            }
            ItemType[] itemTypeArray2 = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                ItemType type = itemTypeArray2[n2];
                type.addTo(((EntityDeathEvent)e).getDrops());
                ++n2;
            }
            return;
        }
        Location[] locationArray = Offset.setOff(this.offsets.getArray(e), this.locations.getArray(e));
        int n = locationArray.length;
        int n3 = 0;
        while (n3 < n) {
            Location l = locationArray[n3];
            if (this.xp != null) {
                Integer exp = this.xp.getSingle(e);
                if (exp != null) {
                    ExperienceOrb orb = (ExperienceOrb)l.getWorld().spawn(l, ExperienceOrb.class);
                    orb.setExperience(exp.intValue());
                }
            } else {
                ItemType[] itemTypeArray3 = types;
                int n4 = types.length;
                int n5 = 0;
                while (n5 < n4) {
                    ItemType type = itemTypeArray3[n5];
                    for (ItemStack is : type.getItem().getAll()) {
                        if (is.getTypeId() == 0) continue;
                        l.getWorld().dropItemNaturally(l, is);
                    }
                    ++n5;
                }
            }
            ++n3;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "drop " + this.items.toString(e, debug) + " " + this.offsets.toString(e, debug) + " " + this.locations.toString(e, debug);
    }
}

