/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config.validate;

import ch.njol.skript.Skript;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.validate.NodeValidator;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Setter;

public class EntryValidator
implements NodeValidator {
    private Setter<String> setter;

    public EntryValidator() {
    }

    public EntryValidator(Setter<String> setter) {
        this.setter = setter;
    }

    @Override
    public boolean validate(Node node) {
        if (!(node instanceof EntryNode)) {
            EntryValidator.notAnEntryError(node);
            return false;
        }
        if (this.setter != null) {
            this.setter.set(((EntryNode)node).getValue());
        }
        return true;
    }

    public static final void notAnEntryError(Node node) {
        SkriptLogger.setNode(node);
        Skript.error("'" + node.getName() + "' is not an entry (like 'blah " + node.getConfig().getSeparator() + " value')");
    }
}

