/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config;

import ch.njol.skript.Skript;
import ch.njol.skript.config.ConfigReader;
import ch.njol.skript.config.SectionNode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class Config {
    File file;
    boolean simple = false;
    private String indentation = null;
    private String indentationName = null;
    final String defaultSeparator;
    String separator;
    String line = "";
    int level = 0;
    private final SectionNode main;
    boolean modified = false;
    int errors = 0;
    final boolean allowEmptySections;

    public Config(File file, boolean simple, boolean allowEmptySections, String defaultSeparator) throws IOException {
        this.file = file;
        this.simple = simple;
        this.allowEmptySections = allowEmptySections;
        this.defaultSeparator = defaultSeparator;
        this.separator = defaultSeparator;
        if (file.length() == 0L) {
            this.main = new SectionNode(this);
            Skript.warning("'" + this.getFileName() + "' is empty");
            return;
        }
        if (Skript.logVeryHigh()) {
            Skript.info("loading '" + file.getName() + "'");
        }
        ConfigReader r = new ConfigReader(file);
        try {
            this.main = SectionNode.load(this, r);
        }
        catch (IOException e) {
            r.close();
            throw e;
        }
        r.close();
    }

    public Config(String s, String fileName, boolean simple, boolean allowEmptySections, String defaultSeparator) throws IOException {
        this.file = new File(fileName);
        this.simple = simple;
        this.allowEmptySections = allowEmptySections;
        this.defaultSeparator = defaultSeparator;
        this.separator = defaultSeparator;
        ConfigReader r = new ConfigReader(s);
        this.main = SectionNode.load(this, r);
        r.close();
    }

    void setIndentation(String indent) {
        this.indentation = indent;
        this.indentationName = indent.charAt(0) == ' ' ? "space" : "tab";
    }

    String getIndentation() {
        return this.indentation;
    }

    String getIndentationName() {
        return this.indentationName;
    }

    public SectionNode getMainNode() {
        return this.main;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public synchronized void save() throws IOException {
        if (!this.modified) {
            return;
        }
        this.separator = this.defaultSeparator;
        this.file.createNewFile();
        PrintWriter w = new PrintWriter(new FileWriter(this.file));
        this.main.save(w);
        w.flush();
        w.close();
        this.modified = false;
    }

    public boolean isEnabled() {
        return !this.file.getName().startsWith("-");
    }

    public boolean setEnabled(boolean b) {
        if (this.isEnabled() == b) {
            return false;
        }
        return this.file.renameTo(new File(this.file, b ? this.file.getName().substring(1) : "-" + this.file.getName()));
    }

    public File getFile() {
        return this.file;
    }

    public String getSeparator() {
        return this.separator;
    }
}

