/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

public class CondIsInWorld
extends Condition {
    private Expression<Entity> entities;
    private Expression<World> worlds;

    static {
        Skript.registerCondition(CondIsInWorld.class, "%entities% (is|are) in [[the] world[s]] %worlds%", "%entities% (is not|isn't|are not|aren't) in [[the] world[s]] %worlds%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.worlds = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.entities.check(e, new Checker<Entity>(){

            @Override
            public boolean check(final Entity en) {
                return CondIsInWorld.this.worlds.check(e, new Checker<World>(){

                    @Override
                    public boolean check(World w) {
                        return en.getWorld() == w;
                    }
                });
            }
        }, this);
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.entities.toString(e, debug)) + " " + (this.entities.isSingle() ? "is" : "are") + " " + (this.isNegated() ? "not" : "") + " in world " + this.worlds.toString(e, debug);
    }
}

