/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CondInventoryContains
extends Condition {
    private Expression<Inventory> invis;
    private Expression<ItemType> items;

    static {
        Skript.registerCondition(CondInventoryContains.class, "%inventories% ha(s|ve) %itemtypes% [in [(the[ir]|his|her|its)] inventory]", "%inventories% contain[s] %itemtypes%", "%inventories% do[es](n't| not) have %itemtypes% [in [(the[ir]|his|her|its)] inventory]", "%inventories% do[es](n't| not) contain %itemtypes%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        this.invis = vars[0];
        this.items = vars[1];
        this.setNegated(matchedPattern >= 2);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.invis.check(e, new Checker<Inventory>(){

            @Override
            public boolean check(Inventory invi) {
                final ItemStack[] buf = invi.getContents();
                return CondInventoryContains.this.items.check(e, new Checker<ItemType>(){

                    @Override
                    public boolean check(ItemType type) {
                        return type.isContainedIn(buf);
                    }
                });
            }
        }, this);
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.invis.toString(e, debug)) + (this.isNegated() ? " doesn't have " : " has ") + this.items.toString(e, debug);
    }
}

