/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Offset;
import ch.njol.skript.util.Slot;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class DefaultConverters {
    static {
        Skript.registerConverter(Number.class, Double.class, new Converter<Number, Double>(){

            @Override
            public Double convert(Number n) {
                return n.doubleValue();
            }
        });
        Skript.registerConverter(Number.class, Float.class, new Converter<Number, Float>(){

            @Override
            public Float convert(Number n) {
                return Float.valueOf(n.floatValue());
            }
        });
        Skript.registerConverter(Short.class, Integer.class, new Converter<Short, Integer>(){

            @Override
            public Integer convert(Short s) {
                return s.intValue();
            }
        });
        Skript.registerConverter(Byte.class, Integer.class, new Converter<Byte, Integer>(){

            @Override
            public Integer convert(Byte b) {
                return b.intValue();
            }
        });
        Skript.registerConverter(OfflinePlayer.class, PlayerInventory.class, new Converter<OfflinePlayer, PlayerInventory>(){

            @Override
            public PlayerInventory convert(OfflinePlayer p) {
                if (!p.isOnline()) {
                    return null;
                }
                return p.getPlayer().getInventory();
            }
        });
        Skript.registerConverter(OfflinePlayer.class, Player.class, new Converter<OfflinePlayer, Player>(){

            @Override
            public Player convert(OfflinePlayer p) {
                return p.getPlayer();
            }
        });
        Skript.registerConverter(CommandSender.class, Player.class, new Converter<CommandSender, Player>(){

            @Override
            public Player convert(CommandSender s) {
                if (s instanceof Player) {
                    return (Player)s;
                }
                return null;
            }
        });
        Skript.registerConverter(Entity.class, Player.class, new Converter<Entity, Player>(){

            @Override
            public Player convert(Entity e) {
                if (e instanceof Player) {
                    return (Player)e;
                }
                return null;
            }
        });
        Skript.registerConverter(Block.class, Inventory.class, new Converter<Block, Inventory>(){

            @Override
            public Inventory convert(Block b) {
                if (b.getState() instanceof InventoryHolder) {
                    return ((InventoryHolder)b.getState()).getInventory();
                }
                return null;
            }
        });
        Skript.registerConverter(Block.class, ItemStack.class, new Converter<Block, ItemStack>(){

            @Override
            public ItemStack convert(Block b) {
                return new ItemStack(b.getTypeId(), 1, (short)b.getData());
            }
        }, 1);
        Skript.registerConverter(Location.class, Block.class, new Converter<Location, Block>(){

            @Override
            public Block convert(Location l) {
                return l.getBlock();
            }
        });
        Skript.registerConverter(Block.class, Location.class, new Converter<Block, Location>(){

            @Override
            public Location convert(Block b) {
                return b.getLocation().add(0.5, 0.5, 0.5);
            }
        });
        Skript.registerConverter(Entity.class, Location.class, new Converter<Entity, Location>(){

            @Override
            public Location convert(Entity e) {
                if (e == null) {
                    return null;
                }
                return e.getLocation();
            }
        });
        Skript.registerConverter(Entity.class, EntityData.class, new Converter<Entity, EntityData>(){

            @Override
            public EntityData convert(Entity e) {
                return EntityData.fromEntity(e);
            }
        });
        Skript.registerConverter(EntityData.class, EntityType.class, new Converter<EntityData, EntityType>(){

            @Override
            public EntityType convert(EntityData data) {
                return new EntityType(data, -1);
            }
        });
        Skript.registerConverter(Location.class, World.class, new Converter<Location, World>(){

            @Override
            public World convert(Location l) {
                if (l == null) {
                    return null;
                }
                return l.getWorld();
            }
        });
        Skript.registerConverter(ItemStack.class, ItemType.class, new Converter<ItemStack, ItemType>(){

            @Override
            public ItemType convert(ItemStack i) {
                if (i == null) {
                    return null;
                }
                return new ItemType(i);
            }
        });
        Skript.registerConverter(Slot.class, ItemStack.class, new Converter<Slot, ItemStack>(){

            @Override
            public ItemStack convert(Slot s) {
                if (s == null) {
                    return null;
                }
                ItemStack i = s.getItem();
                if (i == null) {
                    return new ItemStack(0, 1);
                }
                return i;
            }
        });
        Skript.registerConverter(Item.class, ItemStack.class, new Converter<Item, ItemStack>(){

            @Override
            public ItemStack convert(Item i) {
                if (i == null) {
                    return null;
                }
                return i.getItemStack();
            }
        });
        Skript.registerConverter(OfflinePlayer.class, InventoryHolder.class, new Converter<OfflinePlayer, InventoryHolder>(){

            @Override
            public InventoryHolder convert(OfflinePlayer p) {
                if (p == null || !p.isOnline()) {
                    return null;
                }
                return p.getPlayer();
            }
        });
        Skript.registerConverter(Block.class, InventoryHolder.class, new Converter<Block, InventoryHolder>(){

            @Override
            public InventoryHolder convert(Block b) {
                if (b == null || b.getState() == null) {
                    return null;
                }
                BlockState s = b.getState();
                if (s instanceof InventoryHolder) {
                    return (InventoryHolder)s;
                }
                return null;
            }
        });
        Skript.registerConverter(BlockFace.class, Offset.class, new Converter<BlockFace, Offset>(){

            @Override
            public Offset convert(BlockFace f) {
                return new Offset(f.getModX(), f.getModY(), f.getModZ());
            }
        });
    }
}

