/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.SubLog;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Version;
import ch.njol.util.Callback;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;

public abstract class Variables {
    private static final String varFileName = "variables";
    private static final String varFileExt = "csv";
    private static Task saveTask;
    private static final Map<String, Object> variables;
    private static volatile boolean variablesModded;
    private static final Map<String, WeakHashMap<Event, Object>> localVariables;
    private static final Pattern csv;

    static {
        variables = new HashMap<String, Object>();
        variablesModded = false;
        localVariables = new HashMap<String, WeakHashMap<Event, Object>>();
        csv = Pattern.compile("([^\"\n\r,]+|\"([^\"]|\"\")*\")\\s*(,\\s*|$)");
    }

    private Variables() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setVariable(String name, Object value) {
        Map<String, Object> map = variables;
        synchronized (map) {
            variablesModded = true;
            if (value == null) {
                variables.remove(name);
            } else {
                variables.put(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object getVariable(String name) {
        Map<String, Object> map = variables;
        synchronized (map) {
            return variables.get(name);
        }
    }

    public static final void setLocalVariable(String name, Event e, Object value) {
        WeakHashMap<Object, Object> map = localVariables.get(name);
        if (map == null) {
            map = new WeakHashMap();
            localVariables.put(name, map);
        }
        map.put(e, value);
    }

    public static final Object getLocalVariable(String name, Event e) {
        WeakHashMap<Event, Object> map = localVariables.get(name);
        if (map == null) {
            return null;
        }
        return map.get(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void loadVariables() {
        Map<String, Object> map = variables;
        synchronized (map) {
            Version v1_4;
            boolean ioEx;
            Version varVersion;
            StringBuilder invalid;
            int unsuccessful;
            SubLog log;
            File varFile;
            block55: {
                block53: {
                    File oldFile = new File(Skript.getInstance().getDataFolder(), "variables.yml");
                    varFile = new File(Skript.getInstance().getDataFolder(), "variables.csv");
                    if (oldFile.exists()) {
                        if (varFile.exists()) {
                            Skript.error("Found both a new and an old variable file, ignoring the old one");
                        } else {
                            PrintWriter pw = null;
                            try {
                                try {
                                    pw = new PrintWriter(varFile, "UTF-8");
                                    YamlConfiguration varConfig = YamlConfiguration.loadConfiguration((File)oldFile);
                                    for (Map.Entry e : varConfig.getValues(true).entrySet()) {
                                        if (!(e.getValue() instanceof String)) continue;
                                        String v = (String)e.getValue();
                                        String type = v.substring(v.indexOf(60) + 1, v.indexOf(62));
                                        String value = v.substring(v.indexOf(62) + 1);
                                        pw.println(String.valueOf((String)e.getKey()) + ", " + type + ", \"" + value.replace("\"", "\"\"") + "\"");
                                    }
                                    pw.flush();
                                    oldFile.delete();
                                    Skript.info("[1.3] Converted your variables.yml to the new format and renamed it to variables.csv");
                                }
                                catch (IOException e) {
                                    Skript.error("Error while vonverting the variables to the new format");
                                    if (pw != null) {
                                        pw.close();
                                    }
                                    break block53;
                                }
                            }
                            catch (Throwable throwable) {
                                if (pw != null) {
                                    pw.close();
                                }
                                throw throwable;
                            }
                            if (pw != null) {
                                pw.close();
                            }
                        }
                    }
                }
                try {
                    varFile.createNewFile();
                }
                catch (IOException e) {
                    Skript.error("Cannot create the variables file: " + e.getLocalizedMessage());
                    return;
                }
                if (!varFile.canWrite()) {
                    Skript.error("Cannot write to the variables file - no variables will be saved!");
                }
                if (!varFile.canRead()) {
                    Skript.error("Cannot read from the variables file! Skript will try to create a backup of the file but will likely fail.");
                    try {
                        File backup = FileUtils.backup(varFile);
                        Skript.info("Created a backup of your variables.csv as " + backup.getName());
                    }
                    catch (IOException e) {
                        Skript.error("Failed to create a backup of your variables.csv: " + e.getMessage());
                    }
                    return;
                }
                log = SkriptLogger.startSubLog();
                unsuccessful = 0;
                invalid = new StringBuilder();
                varVersion = Skript.getVersion();
                BufferedReader r = null;
                ioEx = false;
                try {
                    try {
                        r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(varFile), "UTF-8"));
                        String line = null;
                        while ((line = r.readLine()) != null) {
                            if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
                                if (!line.startsWith("# version:")) continue;
                                try {
                                    varVersion = new Version(line.substring("# version:".length()).trim());
                                }
                                catch (IllegalArgumentException illegalArgumentException) {}
                                continue;
                            }
                            String[] split = Variables.splitCSV(line);
                            if (split == null || split.length != 3) {
                                Skript.error("invalid amount of commas in line '" + line + "'");
                                if (invalid.length() != 0) {
                                    invalid.append(", ");
                                }
                                invalid.append(split == null ? "<unknown>" : split[0]);
                                ++unsuccessful;
                                continue;
                            }
                            Object d = Skript.deserialize(split[1], split[2]);
                            if (d == null) {
                                if (invalid.length() != 0) {
                                    invalid.append(", ");
                                }
                                invalid.append(split[0]);
                                ++unsuccessful;
                                continue;
                            }
                            variables.put(split[0], d);
                        }
                    }
                    catch (IOException e) {
                        ioEx = true;
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (IOException e2) {
                                ioEx = true;
                            }
                        }
                        break block55;
                    }
                }
                catch (Throwable throwable) {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException e) {
                            ioEx = true;
                        }
                    }
                    throw throwable;
                }
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException e) {
                        ioEx = true;
                    }
                }
            }
            SkriptLogger.stopSubLog(log);
            if (ioEx || unsuccessful > 0) {
                if (unsuccessful > 0) {
                    Skript.error(String.valueOf(unsuccessful) + " variable" + (unsuccessful == 1 ? "" : "s") + " could not be loaded!");
                    Skript.error("Affected variables: " + invalid.toString());
                    if (log.hasErrors()) {
                        Skript.error("further information:");
                        log.printErrors(null);
                    }
                }
                if (ioEx) {
                    Skript.error("An I/O error occurred while loading the variables");
                }
                try {
                    File backup = FileUtils.backup(varFile);
                    Skript.info("Created a backup of variables.csv as " + backup.getName());
                }
                catch (IOException ex) {
                    Skript.error("Could not backup variables.csv: " + ex.getMessage());
                }
            }
            if ((v1_4 = new Version("1.4")).isLargerThan(varVersion)) {
                int renamed = 0;
                HashMap<String, Object> toAdd = new HashMap<String, Object>();
                Iterator<Map.Entry<String, Object>> iter = variables.entrySet().iterator();
                while (iter.hasNext()) {
                    String newName;
                    Map.Entry<String, Object> e = iter.next();
                    String name = e.getKey();
                    if (!name.contains("<") || name.equals(newName = StringUtils.replaceAll(name, "<(.+?):(.+?)>", new Callback<String, Matcher>(){
                        private final Set<String> keepType = new HashSet<String>(Arrays.asList("entity", "offset", "time", "timespan", "timeperiod", "entitydata", "entitytype"));

                        @Override
                        public String run(Matcher m) {
                            if (this.keepType.contains(m.group(1))) {
                                return String.valueOf(m.group(1)) + ":" + m.group(2);
                            }
                            return m.group(2);
                        }
                    }))) continue;
                    iter.remove();
                    toAdd.put(newName, e.getValue());
                    ++renamed;
                }
                variables.putAll(toAdd);
                if (renamed != 0) {
                    Skript.warning("[1.4] Skript tried to fix " + renamed + " variables!");
                    try {
                        File backup = FileUtils.backup(varFile);
                        Skript.info("Created a backup of your old variables.csv as " + backup.getName());
                    }
                    catch (IOException e) {
                        Skript.error("Failed to create a backup of your old variables.csv: " + e.getMessage());
                    }
                }
            }
        }
    }

    private static final String[] splitCSV(String line) {
        Matcher m = csv.matcher(line);
        int lastEnd = 0;
        ArrayList<String> r = new ArrayList<String>();
        while (m.find()) {
            if (lastEnd != m.start()) {
                return null;
            }
            if (m.group(1).startsWith("\"")) {
                r.add(m.group(1).substring(1, m.group(1).length() - 1).replace("\"\"", "\""));
            } else {
                r.add(m.group(1));
            }
            lastEnd = m.end();
        }
        if (lastEnd != line.length()) {
            return null;
        }
        return r.toArray(new String[r.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void saveVariables() {
        Map<String, Object> map = variables;
        synchronized (map) {
            block12: {
                File varFile = new File(Skript.getInstance().getDataFolder(), "variables.csv");
                PrintWriter pw = null;
                try {
                    try {
                        pw = new PrintWriter(varFile, "UTF-8");
                        pw.println("# Skript's variable storage");
                        pw.println("# Please do not modify this file manually!");
                        pw.println("#");
                        pw.println("# version: " + Skript.getInstance().getDescription().getVersion());
                        pw.println();
                        for (Map.Entry<String, Object> e : variables.entrySet()) {
                            Pair<String, String> s;
                            if (e.getValue() == null || (s = Skript.serialize(e.getValue())) == null) continue;
                            pw.println(String.valueOf(e.getKey()) + ", " + (String)s.first + ", " + (String)s.second);
                        }
                        pw.flush();
                    }
                    catch (IOException e) {
                        Skript.error("Unable to save variables: " + e.getLocalizedMessage());
                        if (pw != null) {
                            pw.close();
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (pw != null) {
                        pw.close();
                    }
                    throw throwable;
                }
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    static void scheduleSaveTask() {
        saveTask = new Task(Skript.getInstance(), 600L, 600L, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (variablesModded) {
                    Map map = variables;
                    synchronized (map) {
                        Variables.saveVariables();
                        variablesModded = false;
                    }
                }
            }
        };
    }

    public static void cancelSaveTask() {
        saveTask.cancel();
    }
}

