/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Aliases;
import ch.njol.skript.Language;
import ch.njol.skript.ScriptLoader;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.Variables;
import ch.njol.skript.classes.ChainedConverter;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.classes.InverseComparator;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.classes.data.BukkitClasses;
import ch.njol.skript.classes.data.BukkitEventValues;
import ch.njol.skript.classes.data.DefaultClasses;
import ch.njol.skript.classes.data.DefaultComparators;
import ch.njol.skript.classes.data.DefaultConverters;
import ch.njol.skript.classes.data.SkriptClasses;
import ch.njol.skript.command.Commands;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.EnumEntryValidator;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.VariableString;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.SubLog;
import ch.njol.skript.log.Verbosity;
import ch.njol.skript.util.CommandHelp;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.Version;
import ch.njol.util.Pair;
import ch.njol.util.ReversedListView;
import ch.njol.util.Setter;
import ch.njol.util.Validate;
import ch.njol.util.iterator.EnumerationIterable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Skript
extends JavaPlugin
implements Listener {
    private static Skript instance = null;
    private static Version version = null;
    private static boolean disabled = false;
    private static boolean runningCraftBukkit;
    private static final CommandHelp skriptCommandHelp;
    public static final String SCRIPTSFOLDER = "scripts";
    public static final String quotesError = "Invalid use of quotes (\"). If you want to use quotes in \"quoted text\", double them: \"\".";
    public static final double EPSILON = 1.0E-10;
    public static final double EPSILON_MULT = 1.00001;
    public static final int MAXBLOCKID = 255;
    public static final int TARGETBLOCKMAXDISTANCE = 100;
    public static final int NUMBERACCURACY = 2;
    public static final Random random;
    static EventPriority defaultEventPriority;
    private static DateFormat dateFormat;
    public static boolean disableVariableConflictWarnings;
    static boolean listenerEnabled;
    private static boolean acceptRegistrations;
    private static final Collection<SyntaxElementInfo<? extends Condition>> conditions;
    private static final Collection<SyntaxElementInfo<? extends Effect>> effects;
    private static final Collection<SyntaxElementInfo<? extends Statement>> statements;
    private static final List<ExpressionInfo<?, ?>> expressions;
    private static final int[] expressionTypesStartIndices;
    private static final Collection<SkriptEvent.SkriptEventInfo<?>> events;
    private static List<Converter.ConverterInfo<?, ?>> converters;
    private static final List<ClassInfo<?>> classInfos;
    private static final HashMap<Class<?>, ClassInfo<?>> exactClassInfos;
    private static final HashMap<Class<?>, ClassInfo<?>> superClassInfos;
    private static final Collection<Comparator.ComparatorInfo<?, ?>> comparators;
    private static final List<EventValueInfo<?, ?>> defaultEventValues;
    private static final List<EventValueInfo<?, ?>> pastEventValues;
    private static final List<EventValueInfo<?, ?>> futureEventValues;
    private static final String EXCEPTION_PREFIX = "##!! ";
    static Config mainConfig;
    static final ArrayList<Config> configs;
    static boolean keepConfigsLoaded;
    public static boolean enableEffectCommands;
    public static String effectCommandToken;

    static {
        skriptCommandHelp = new CommandHelp("<gray>/<gold>skript", "Skript's main command", "cyan").add(new CommandHelp("reload", "Reloads the config, all scripts, everything, or a specific script", "red").add("all", "Reloads the config and all scripts").add("config", "Reloads the config").add(SCRIPTSFOLDER, "Reloads all scripts").add("<script>", "Reloads a specific script")).add(new CommandHelp("enable", "Enables all scripts or a specific one", "red").add("all", "Enables all scripts").add("<script>", "Enables a specific script")).add(new CommandHelp("disable", "Disables all scripts or a specific one", "red").add("all", "Disables all scripts").add("<script>", "Disables a specific script")).add("help", "Prints this help message");
        random = new Random();
        defaultEventPriority = EventPriority.NORMAL;
        dateFormat = DateFormat.getDateTimeInstance(3, 3);
        listenerEnabled = true;
        acceptRegistrations = true;
        conditions = new ArrayList<SyntaxElementInfo<? extends Condition>>(20);
        effects = new ArrayList<SyntaxElementInfo<? extends Effect>>(20);
        statements = new ArrayList<SyntaxElementInfo<? extends Statement>>(40);
        expressions = new ArrayList(30);
        expressionTypesStartIndices = new int[ExpressionType.values().length];
        events = new ArrayList(50);
        converters = new ArrayList(50);
        classInfos = new ArrayList(50);
        exactClassInfos = new HashMap();
        superClassInfos = new HashMap();
        comparators = new ArrayList();
        defaultEventValues = new ArrayList(30);
        pastEventValues = new ArrayList();
        futureEventValues = new ArrayList();
        configs = new ArrayList();
        keepConfigsLoaded = false;
        enableEffectCommands = false;
        effectCommandToken = "!";
    }

    public static Skript getInstance() {
        return instance;
    }

    public static Version getVersion() {
        return version;
    }

    public Skript() throws IllegalAccessException {
        if (instance != null) {
            throw new IllegalAccessException();
        }
        instance = this;
    }

    public void onEnable() {
        if (disabled) {
            throw new IllegalStateException("Skript may only be reloaded by either Bukkit's '/reload' or Skript's '/skript reload' command");
        }
        Language.loadDefault();
        version = new Version(this.getDescription().getVersion());
        runningCraftBukkit = Bukkit.getServer().getClass().getName().equals("org.bukkit.craftbukkit.CraftServer");
        new DefaultClasses();
        new BukkitClasses();
        new BukkitEventValues();
        new SkriptClasses();
        new DefaultComparators();
        new DefaultConverters();
        try {
            Skript.loadClasses("ch.njol.skript.conditions", false);
            Skript.loadClasses("ch.njol.skript.effects", false);
            Skript.loadClasses("ch.njol.skript.events", false);
            Skript.loadClasses("ch.njol.skript.expressions", false);
            Skript.loadClasses("ch.njol.skript.entity", false);
        }
        catch (Exception e) {
            Skript.exception(e, "could not load required .class files");
            this.setEnabled(false);
            return;
        }
        if (!this.getDataFolder().isDirectory()) {
            this.getDataFolder().mkdirs();
        }
        this.loadMainConfig();
        Commands.registerListener();
        if (Skript.logNormal()) {
            Skript.info(" ~ created by & \u00a9 Peter G\u00fcttinger aka Njol ~");
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Skript.stopAcceptingRegistrations();
                Variables.loadVariables();
                ScriptLoader.loadScripts();
                Skript.info("Skript finished loading!");
            }
        });
        Variables.scheduleSaveTask();
        if (Bukkit.getOnlineMode()) {
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onJoin(PlayerJoinEvent e) {
                    if (e.getPlayer().getName().equalsIgnoreCase("Njol")) {
                        e.getPlayer().sendMessage("This server is running Skript v" + Skript.this.getDescription().getVersion() + " :3");
                    }
                }
            }, (Plugin)this);
        }
    }

    public static boolean isRunningCraftBukkit() {
        return runningCraftBukkit;
    }

    private static final void disableScripts() {
        configs.clear();
        for (Trigger t : ScriptLoader.selfRegisteredTriggers) {
            t.getEvent().unregisterAll();
        }
        ScriptLoader.selfRegisteredTriggers.clear();
        VariableString.variableNames.clear();
        SkriptEventHandler.triggers.clear();
        Commands.clearCommands();
    }

    private static final void reload() {
        Skript.disableScripts();
        Skript.reloadMainConfig();
        ScriptLoader.loadScripts();
    }

    private static final void reloadScripts() {
        Skript.disableScripts();
        ScriptLoader.loadScripts();
    }

    private static final void reloadMainConfig() {
        Aliases.clear();
        Language.clear();
        Skript.getInstance().loadMainConfig();
    }

    public void onDisable() {
        disabled = true;
        Variables.cancelSaveTask();
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        Variables.saveVariables();
        Skript.disableScripts();
        new Thread(new Runnable(){

            @Override
            public void run() {
                block11: {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        Field modifiers = Field.class.getDeclaredField("modifiers");
                        modifiers.setAccessible(true);
                        JarFile jar = new JarFile(Skript.this.getFile());
                        for (JarEntry e : new EnumerationIterable<JarEntry>(jar.entries())) {
                            if (!e.getName().endsWith(".class")) continue;
                            try {
                                Class<?> c = Class.forName(e.getName().replace('/', '.').substring(0, e.getName().length() - ".class".length()), false, Skript.this.getClassLoader());
                                if (c == null) continue;
                                Field[] fieldArray = c.getDeclaredFields();
                                int n = fieldArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Field f = fieldArray[n2];
                                    if (Modifier.isStatic(f.getModifiers()) && !f.getType().isPrimitive()) {
                                        if (Modifier.isFinal(f.getModifiers())) {
                                            modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                                        }
                                        f.setAccessible(true);
                                        f.set(null, null);
                                    }
                                    ++n2;
                                }
                            }
                            catch (Throwable ex) {
                                if (!$assertionsDisabled && !(ex instanceof NoClassDefFoundError)) {
                                    throw new AssertionError();
                                }
                            }
                        }
                    }
                    catch (Throwable ex) {
                        if ($assertionsDisabled) break block11;
                        throw new AssertionError();
                    }
                }
            }
        }).start();
    }

    private static final void message(CommandSender recipient, String message) {
        recipient.sendMessage(Utils.prepareMessage("<grey>[<gold>Skript<grey>]<reset> " + message));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!skriptCommandHelp.test(sender, args)) {
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (args[1].equalsIgnoreCase("all")) {
                SubLog log = SkriptLogger.startSubLog();
                Skript.reload();
                log.stop();
                if (log.hasErrors()) {
                    Skript.message(sender, "Error(s) while reloading the config and all scripts:");
                    log.printErrors(sender, null);
                    return true;
                } else {
                    Skript.message(sender, "Successfully reloaded the config and all scripts");
                }
                return true;
            }
            if (args[1].equalsIgnoreCase(SCRIPTSFOLDER)) {
                SubLog log = SkriptLogger.startSubLog();
                Skript.reloadScripts();
                log.stop();
                if (log.hasErrors()) {
                    Skript.message(sender, "Error(s) while reloading all scripts:");
                    log.printErrors(sender, null);
                    return true;
                } else {
                    Skript.message(sender, "Successfully reloaded all scripts");
                }
                return true;
            }
            if (args[1].equalsIgnoreCase("config")) {
                SubLog log = SkriptLogger.startSubLog();
                Skript.reloadMainConfig();
                log.stop();
                if (log.hasErrors()) {
                    Skript.message(sender, "Error(s) while reloading the main config:");
                    log.printErrors(sender, null);
                    return true;
                } else {
                    Skript.message(sender, "Successfully reloaded the main config");
                }
                return true;
            }
            File f = this.getScriptFromArgs(sender, args, 1);
            if (f == null) {
                return true;
            }
            if (f.getName().startsWith("-")) {
                Skript.message(sender, "This script is currently disabled. Use <gray>/<gold>skript <cyan>enable <red>" + f.getName().substring(1, f.getName().length() - 3) + "<reset> to enable it.");
                return true;
            }
            ScriptLoader.unloadScript(f);
            SubLog log = SkriptLogger.startSubLog();
            ScriptLoader.loadScript(f);
            log.stop();
            if (log.hasErrors()) {
                Skript.message(sender, "Error(s) while reloading <gold>" + f.getName() + "<reset>:");
                log.printErrors(sender, null);
                return true;
            } else {
                Skript.message(sender, "Successfully reloaded <gold>" + f.getName() + "<reset>!");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("enable")) {
            if (args[1].equals("all")) {
                try {
                    Collection<File> files = Skript.toggleScripts(true);
                    SubLog log = SkriptLogger.startSubLog();
                    ScriptLoader.loadScripts(files);
                    log.stop();
                    if (log.hasErrors()) {
                        Skript.message(sender, "Error(s) while loading disabled scripts:");
                        log.printErrors(sender, null);
                        return true;
                    }
                    Skript.message(sender, "Successfully loaded & enabled all previously disabled scripts!");
                    return true;
                }
                catch (IOException e) {
                    Skript.message(sender, "Could not enable any scripts (some scripts might however have been renamed already): " + e.getLocalizedMessage());
                }
                return true;
            }
            File f = this.getScriptFromArgs(sender, args, 1);
            if (f == null) {
                return true;
            }
            if (!f.getName().startsWith("-")) {
                Skript.message(sender, "<gold>" + f.getName() + "<reset> is already enabled!");
                return true;
            }
            try {
                FileUtils.move(f, new File(f.getParentFile(), f.getName().substring(1)));
            }
            catch (IOException e) {
                Skript.message(sender, "Could not enable <gold>" + f.getName().substring(1) + "<reset>: " + e.getLocalizedMessage());
                return true;
            }
            f = new File(f.getParentFile(), f.getName().substring(1));
            SubLog log = SkriptLogger.startSubLog();
            ScriptLoader.loadScript(f);
            log.stop();
            if (log.hasErrors()) {
                Skript.message(sender, "Error(s) while enabling <gold>" + f.getName() + "<reset>:");
                log.printErrors(sender, null);
                return true;
            } else {
                Skript.message(sender, "Successfully enabled <gold>" + f.getName() + "<reset>!");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("disable")) {
            if (args[1].equals("all")) {
                Skript.disableScripts();
                try {
                    Skript.toggleScripts(false);
                    Skript.message(sender, "Successfully disabled all scripts!");
                    return true;
                }
                catch (IOException e) {
                    Skript.message(sender, "Could not rename all scripts - some scripts will be enabled again when you restart the server: " + e.getLocalizedMessage());
                }
                return true;
            }
            File f = this.getScriptFromArgs(sender, args, 1);
            if (f == null) {
                return true;
            }
            if (f.getName().startsWith("-")) {
                Skript.message(sender, "<gold>" + f.getName().substring(1) + "<reset> is already disabled!");
                return true;
            }
            ScriptLoader.unloadScript(f);
            try {
                FileUtils.move(f, new File(f.getParentFile(), "-" + f.getName()));
            }
            catch (IOException e) {
                Skript.message(sender, "Could not rename <gold>" + f.getName() + "<reset>, it will be enabled again when you restart the server: " + e.getLocalizedMessage());
                return true;
            }
            Skript.message(sender, "Successfully disabled <gold>" + f.getName() + "<reset>!");
            return true;
        }
        if (!args[0].equalsIgnoreCase("help")) return true;
        skriptCommandHelp.showHelp(sender);
        return true;
    }

    private File getScriptFromArgs(CommandSender sender, String[] args, int start) {
        File f;
        StringBuilder b = new StringBuilder();
        int i = 1;
        while (i < args.length) {
            b.append(" " + args[i]);
            ++i;
        }
        String script = b.toString().trim();
        if (!script.endsWith(".sk")) {
            script = String.valueOf(script) + ".sk";
        }
        if (script.startsWith("-")) {
            script = script.substring(1);
        }
        if (!(f = new File(this.getDataFolder(), SCRIPTSFOLDER + File.separator + script)).exists() && !(f = new File(this.getDataFolder(), SCRIPTSFOLDER + File.separator + "-" + script)).exists()) {
            Skript.message(sender, "Can't find the script <grey>'<gold>" + script + "<grey>'<reset> in the scripts folder!");
            return null;
        }
        return f;
    }

    private static final Collection<File> toggleScripts(final boolean enable) throws IOException {
        return FileUtils.renameAll(new File(Skript.getInstance().getDataFolder(), SCRIPTSFOLDER), new Converter<String, String>(){

            @Override
            public String convert(String name) {
                if (name.startsWith("-") == enable) {
                    return enable ? name.substring(1) : "-" + name;
                }
                return null;
            }
        });
    }

    private static void loadClasses(String packageName, boolean loadSubPackages) throws IOException {
        JarFile jar = new JarFile(Skript.getInstance().getFile());
        String packageWithSlashes = String.valueOf(packageName.replace('.', '/')) + "/";
        for (JarEntry e : new EnumerationIterable<JarEntry>(jar.entries())) {
            if (!e.getName().startsWith(packageWithSlashes) || !e.getName().endsWith(".class") || !loadSubPackages && e.getName().lastIndexOf(47) != packageWithSlashes.length() - 1) continue;
            String c = e.getName().replace('/', '.').substring(0, e.getName().length() - ".class".length());
            try {
                Class.forName(c);
            }
            catch (ClassNotFoundException ex) {
                Skript.exception(ex, "cannot load class " + c);
            }
        }
    }

    public static void outdatedError() {
        Skript.error("Skript v" + instance.getDescription().getVersion() + " is not fully compatible with CraftBukkit " + Bukkit.getVersion() + ". Some feature(s) will be broken until you update Skript.");
    }

    public static void outdatedError(Exception e) {
        Skript.outdatedError();
        e.printStackTrace();
    }

    public static EventPriority getDefaultEventPriority() {
        return defaultEventPriority;
    }

    public static <T> T[] array(T ... array) {
        return array;
    }

    public static DateFormat getDateFormat() {
        return dateFormat;
    }

    public static final int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return s.startsWith("-") ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
    }

    public static void disableListener() {
        listenerEnabled = false;
    }

    public static void enableListener() {
        listenerEnabled = true;
    }

    private static void checkAcceptRegistrations() {
        if (!acceptRegistrations) {
            throw new SkriptAPIException("Registering is disabled after initialization!");
        }
    }

    private static void stopAcceptingRegistrations() {
        acceptRegistrations = false;
        Skript.createMissingConverters();
    }

    public static <E extends Condition> void registerCondition(Class<E> condition, String ... patterns) {
        Skript.checkAcceptRegistrations();
        SyntaxElementInfo<E> info = new SyntaxElementInfo<E>(patterns, condition);
        conditions.add(info);
        statements.add(info);
    }

    public static <E extends Effect> void registerEffect(Class<E> effect, String ... patterns) {
        Skript.checkAcceptRegistrations();
        SyntaxElementInfo<E> info = new SyntaxElementInfo<E>(patterns, effect);
        effects.add(info);
        statements.add(info);
    }

    public static Collection<SyntaxElementInfo<? extends Statement>> getStatements() {
        return statements;
    }

    public static Collection<SyntaxElementInfo<? extends Condition>> getConditions() {
        return conditions;
    }

    public static Collection<SyntaxElementInfo<? extends Effect>> getEffects() {
        return effects;
    }

    public static <E extends Expression<T>, T> void registerExpression(Class<E> c, Class<T> returnType, ExpressionType type, String ... patterns) {
        Skript.checkAcceptRegistrations();
        int i = type.ordinal() + 1;
        while (i < ExpressionType.values().length) {
            int n = i++;
            expressionTypesStartIndices[n] = expressionTypesStartIndices[n] + 1;
        }
        expressions.add(expressionTypesStartIndices[type.ordinal()], new ExpressionInfo<E, T>(patterns, returnType, c));
    }

    public static List<ExpressionInfo<?, ?>> getExpressions() {
        return expressions;
    }

    public static <E extends SkriptEvent> void registerEvent(Class<E> c, Class<? extends Event> event, String ... patterns) {
        Skript.checkAcceptRegistrations();
        events.add(new SkriptEvent.SkriptEventInfo<E>(patterns, c, Skript.array(event), true));
    }

    public static <E extends SkriptEvent> void registerEvent(Class<E> c, Class<? extends Event>[] events, String ... patterns) {
        Skript.checkAcceptRegistrations();
        Skript.events.add(new SkriptEvent.SkriptEventInfo<E>(patterns, c, events, true));
    }

    public static <E extends SkriptEvent> void registerEvent(Class<E> c, Class<? extends Event> event, boolean fire, String ... patterns) {
        Skript.checkAcceptRegistrations();
        events.add(new SkriptEvent.SkriptEventInfo<E>(patterns, c, Skript.array(event), fire));
    }

    public static final Collection<SkriptEvent.SkriptEventInfo<?>> getEvents() {
        return events;
    }

    public static <F, T> void registerConverter(Class<F> from, Class<T> to, Converter<F, T> converter) {
        Skript.registerConverter(from, to, converter, 0);
    }

    public static <F, T> void registerConverter(Class<F> from, Class<T> to, Converter<F, T> converter, int options) {
        Skript.checkAcceptRegistrations();
        converters.add(new Converter.ConverterInfo<F, T>(from, to, converter, options));
    }

    private static void createMissingConverters() {
        int i = 0;
        while (i < converters.size()) {
            Converter.ConverterInfo<?, ?> info = converters.get(i);
            int j = 0;
            while (j < converters.size()) {
                Converter.ConverterInfo<?, ?> info2 = converters.get(j);
                if ((info.options & 2) == 0 && (info2.options & 1) == 0 && info2.from.isAssignableFrom(info.to) && !Skript.converterExists(info.from, info2.to)) {
                    converters.add(Skript.createChainedConverter(info, info2));
                } else if ((info.options & 1) == 0 && (info2.options & 2) == 0 && info.from.isAssignableFrom(info2.to) && !Skript.converterExists(info2.from, info.to)) {
                    converters.add(Skript.createChainedConverter(info2, info));
                }
                ++j;
            }
            ++i;
        }
    }

    private static <F, M, T> Converter.ConverterInfo<F, T> createChainedConverter(Converter.ConverterInfo<?, ?> first, Converter.ConverterInfo<?, ?> second) {
        return new Converter.ConverterInfo(first.from, second.to, new ChainedConverter(first.converter, second.converter), first.options | second.options);
    }

    public static final boolean converterExists(Class<?> from, Class<?> to) {
        Validate.notNull(from, to);
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!conv.from.isAssignableFrom(from) || !to.isAssignableFrom(conv.to)) continue;
            return true;
        }
        return false;
    }

    public static <F, T> T convert(F o, Class<T> to) {
        Validate.notNull(to, "to");
        if (o == null) {
            return null;
        }
        if (to.isInstance(o)) {
            return (T)o;
        }
        Converter<?, T> conv = Skript.getConverter(o.getClass(), to);
        if (conv == null) {
            return null;
        }
        return conv.convert(o);
    }

    public static final <F, T> Converter<? super F, ? extends T> getConverter(Class<F> from, Class<T> to) {
        Validate.notNull(from, to);
        Converter.ConverterInfo<F, T> ci = Skript.getConverterInfo(from, to);
        if (ci != null) {
            return ci.converter;
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (conv.from.isAssignableFrom(from) && conv.to.isAssignableFrom(to)) {
                return Converter.ConverterUtils.createInstanceofConverter(conv.converter, to);
            }
            if (!from.isAssignableFrom(conv.from) || !to.isAssignableFrom(conv.to)) continue;
            return Converter.ConverterUtils.createInstanceofConverter(conv);
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!from.isAssignableFrom(conv.from) || !conv.to.isAssignableFrom(to)) continue;
            return Converter.ConverterUtils.createDoubleInstanceofConverter(conv, to);
        }
        return null;
    }

    private static final <F, T> Converter.ConverterInfo<? super F, ? extends T> getConverterInfo(Class<F> from, Class<T> to) {
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!conv.from.isAssignableFrom(from) || !to.isAssignableFrom(conv.to)) continue;
            return conv;
        }
        return null;
    }

    public static <T> void registerClass(ClassInfo<T> info) {
        Skript.checkAcceptRegistrations();
        exactClassInfos.put(info.getC(), info);
        int i = 0;
        while (i < classInfos.size()) {
            if (classInfos.get(i).getC().isAssignableFrom(info.getC())) {
                classInfos.add(i, info);
                return;
            }
            ++i;
        }
        classInfos.add(info);
    }

    public static <T> void registerClass(ClassInfo<T> info, String ... before) {
        Skript.checkAcceptRegistrations();
        exactClassInfos.put(info.getC(), info);
        int i = 0;
        while (i < classInfos.size()) {
            if (classInfos.get(i).getC().isAssignableFrom(info.getC()) || Utils.contains(before, classInfos.get(i).getCodeName())) {
                classInfos.add(i, info);
                return;
            }
            ++i;
        }
        classInfos.add(info);
    }

    public static List<ClassInfo<?>> getClassInfos() {
        return classInfos;
    }

    public static ClassInfo<?> getClassInfo(String codeName) {
        for (ClassInfo<?> ci : classInfos) {
            if (!ci.getCodeName().equals(codeName)) continue;
            return ci;
        }
        throw new SkriptAPIException("no class info found for " + codeName);
    }

    public static <T> ClassInfo<T> getExactClassInfo(Class<T> c) {
        return exactClassInfos.get(c);
    }

    public static <T> ClassInfo<? super T> getSuperClassInfo(Class<T> c) {
        ClassInfo<?> i = superClassInfos.get(c);
        if (i != null) {
            return i;
        }
        for (ClassInfo<?> ci : classInfos) {
            if (!ci.getC().isAssignableFrom(c)) continue;
            if (!acceptRegistrations) {
                superClassInfos.put(c, ci);
            }
            return ci;
        }
        return null;
    }

    public static Class<?> getClass(String codeName) {
        return Skript.getClassInfo(codeName).getC();
    }

    public static ClassInfo<?> getClassInfoFromUserInput(String name) {
        name = name.toLowerCase();
        for (ClassInfo<?> ci : classInfos) {
            if (ci.getUserInputPatterns() == null) continue;
            Pattern[] patternArray = ci.getUserInputPatterns();
            int n = patternArray.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pattern = patternArray[n2];
                if (pattern.matcher(name).matches()) {
                    return ci;
                }
                ++n2;
            }
        }
        return null;
    }

    public static Class<?> getClassFromUserInput(String name) {
        ClassInfo<?> ci = Skript.getClassInfoFromUserInput(name);
        return ci == null ? null : ci.getC();
    }

    public static Class<?> getClassByName(String name) {
        for (ClassInfo<?> ci : classInfos) {
            if (!ci.getName().equalsIgnoreCase(name)) continue;
            return ci.getC();
        }
        return null;
    }

    public static DefaultExpression<?> getDefaultExpression(String codeName) {
        return Skript.getClassInfo(codeName).getDefaultExpression();
    }

    public static <T> DefaultExpression<T> getDefaultExpression(Class<T> c) {
        ClassInfo<?> ci = exactClassInfos.get(c);
        return ci == null ? null : ci.getDefaultExpression();
    }

    public static final String getExactClassName(Class<?> c) {
        ClassInfo<?> ci = exactClassInfos.get(c);
        return ci == null ? null : ci.getCodeName();
    }

    public static <T> T parseSimple(String s, Class<T> c, ParseContext context) {
        SubLog log = SkriptLogger.startSubLog();
        for (ClassInfo<?> info : classInfos) {
            if (info.getParser() == null || !c.isAssignableFrom(info.getC())) continue;
            log.clear();
            Object t = info.getParser().parse(s, context);
            if (t == null) continue;
            SkriptLogger.stopSubLog(log);
            log.printLog();
            return (T)t;
        }
        SkriptLogger.stopSubLog(log);
        return null;
    }

    public static <T> T parse(String s, Class<T> c, ParseContext context) {
        Object t = Skript.parseSimple(s, c, context);
        if (t != null) {
            return t;
        }
        SubLog log = SkriptLogger.startSubLog();
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!c.isAssignableFrom(conv.to)) continue;
            log.clear();
            Object o = Skript.parseSimple(s, conv.from, context);
            if (o == null || (t = Converter.ConverterUtils.convert(conv, o)) == null) continue;
            SkriptLogger.stopSubLog(log);
            log.printLog();
            return t;
        }
        SkriptLogger.stopSubLog(log);
        return null;
    }

    public static final <T> Parser<? extends T> getParser(Class<T> to) {
        for (ClassInfo<?> classInfo : new ReversedListView(classInfos)) {
            if (!to.isAssignableFrom(classInfo.getC()) || classInfo.getParser() == null) continue;
            return classInfo.getParser();
        }
        for (Converter.ConverterInfo converterInfo : converters) {
            if (!to.isAssignableFrom(converterInfo.to)) continue;
            for (ClassInfo<?> ci : new ReversedListView(classInfos)) {
                if (!converterInfo.from.isAssignableFrom(ci.getC()) || ci.getParser() == null) continue;
                return Skript.createConvertedParser(ci.getParser(), converterInfo.converter);
            }
        }
        return null;
    }

    private static final <F, T> Parser<T> createConvertedParser(final Parser<?> parser, final Converter<F, T> converter) {
        return new Parser<T>(){

            @Override
            public T parse(String s, ParseContext context) {
                Object f = parser.parse(s, context);
                if (f == null) {
                    return null;
                }
                return converter.convert(f);
            }

            @Override
            public String toString(T o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String toCodeString(T o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String toString(Object o) {
        return Skript.toString(o, StringMode.MESSAGE, false);
    }

    public static String getDebugMessage(Object o) {
        return Skript.toString(o, StringMode.DEBUG, false);
    }

    public static final String toString(Object[] os, boolean and) {
        return Skript.toString(os, and, StringMode.MESSAGE, false);
    }

    public static final <T> String toString(T o, StringMode mode, boolean plural) {
        boolean code;
        boolean bl = code = mode == StringMode.VARIABLE_NAME;
        if (o == null) {
            return "<none>";
        }
        if (o.getClass().isArray()) {
            if (((Object[])o).length == 0) {
                return "<none>";
            }
            StringBuilder b = new StringBuilder();
            boolean first = true;
            Object[] objectArray = (Object[])o;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object i = objectArray[n2];
                if (!first) {
                    b.append(", ");
                }
                b.append(Skript.toString(i, mode, plural));
                first = false;
                ++n2;
            }
            return "[" + b.toString() + "]";
        }
        for (ClassInfo<?> ci : classInfos) {
            String s;
            if (ci.getParser() == null || !ci.getC().isAssignableFrom(o.getClass())) continue;
            String string = s = code ? ci.getParser().toCodeString(o) : Utils.toPlural(ci.getParser().toString(o, mode), plural);
            if (s == null) continue;
            return s;
        }
        return code ? "object:" + o : String.valueOf(o);
    }

    public static final String toString(Object[] os, boolean and, StringMode mode, boolean plural) {
        if (os.length == 0) {
            return Skript.toString(null);
        }
        if (os.length == 1) {
            return Skript.toString(os[0], mode, plural);
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < os.length) {
            if (i != 0) {
                if (i == os.length - 1) {
                    b.append(and ? " and " : " or ");
                } else {
                    b.append(", ");
                }
            }
            b.append(Skript.toString(os[i], mode, plural));
            ++i;
        }
        return b.toString();
    }

    public static final Pair<String, String> serialize(Object o) {
        ClassInfo<?> ci = Skript.getSuperClassInfo(o.getClass());
        if (ci == null) {
            return null;
        }
        if (ci.getSerializeAs() != null) {
            ClassInfo<?> as = Skript.getExactClassInfo(ci.getSerializeAs());
            if (as == null || as.getSerializer() == null) {
                throw new SkriptAPIException(String.valueOf(ci.getSerializeAs().getName()) + ", the class to serialize " + o.getClass().getName() + " as, is not registered or not serializable");
            }
            Object s = Skript.convert(o, as.getC());
            if (s == null) {
                return null;
            }
            return new Pair<String, String>(as.getCodeName(), Skript.serialize(as.getSerializer(), s));
        }
        if (ci.getSerializer() != null) {
            return new Pair<String, String>(ci.getCodeName(), Skript.serialize(ci.getSerializer(), o));
        }
        return null;
    }

    private static final <T> String serialize(Serializer<T> serializer, Object o) {
        String s = serializer.serialize(o);
        if (s.contains("\n") || s.contains("\r") || s.contains("\"") || s.contains(",")) {
            return String.valueOf('\"') + s.replace("\"", "\"\"") + '\"';
        }
        return s;
    }

    public static final Object deserialize(String type, String value) {
        ClassInfo<?> ci = Skript.getClassInfo(type);
        if (ci == null || ci.getSerializer() == null) {
            return null;
        }
        return ci.getSerializer().deserialize(value);
    }

    public static <T1, T2> void registerComparator(Class<T1> t1, Class<T2> t2, Comparator<T1, T2> c) {
        Skript.checkAcceptRegistrations();
        if (t1 == Object.class || t2 == Object.class) {
            throw new IllegalArgumentException("must not add a comparator for Object");
        }
        comparators.add(new Comparator.ComparatorInfo<T1, T2>(t1, t2, c));
    }

    public static final Collection<Comparator.ComparatorInfo<?, ?>> getComparators() {
        return comparators;
    }

    public static <T1, T2> Comparator.Relation compare(T1 t1, T2 t2) {
        for (Comparator.ComparatorInfo<?, ?> info : comparators) {
            if (info.c1.isInstance(t1) && info.c2.isInstance(t2)) {
                return info.c.compare(t1, t2);
            }
            if (!info.c1.isInstance(t2) || !info.c2.isInstance(t1)) continue;
            return info.c.compare(t2, t1);
        }
        if (t1 != null && t1.getClass().isInstance(t2)) {
            return Comparator.Relation.get(t1.equals(t2));
        }
        if (t2 != null && t2.getClass().isInstance(t1)) {
            return Comparator.Relation.get(t2.equals(t1));
        }
        return null;
    }

    public static <T1, T2> Comparator<T1, T2> getComparator(Class<T1> c1, Class<T2> c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        for (Comparator.ComparatorInfo<?, ?> c : comparators) {
            if (c.c1.isAssignableFrom(c1) && c.c2.isAssignableFrom(c2)) {
                return c.c;
            }
            if (!c.c1.isAssignableFrom(c2) || !c.c2.isAssignableFrom(c1)) continue;
            return new InverseComparator(c.c);
        }
        return null;
    }

    private static final List<EventValueInfo<?, ?>> getEventValuesList(int time) {
        if (time == -1) {
            return pastEventValues;
        }
        if (time == 0) {
            return defaultEventValues;
        }
        if (time == 1) {
            return futureEventValues;
        }
        throw new IllegalArgumentException("time must be -1, 0, or 1");
    }

    public static <T, E extends Event> void registerEventValue(Class<E> e, Class<T> c, Getter<T, E> g, int time) {
        Skript.registerEventValue(e, c, g, time, null, null);
    }

    public static <T, E extends Event> void registerEventValue(Class<E> e, Class<T> c, Getter<T, E> g, int time, String excludeErrorMessage, Class<? extends E> ... excludes) {
        Skript.checkAcceptRegistrations();
        List<EventValueInfo<?, ?>> eventValues = Skript.getEventValuesList(time);
        int i = 0;
        while (i < eventValues.size()) {
            EventValueInfo<?, ?> info = eventValues.get(i);
            if (info.event.isAssignableFrom(e) && info.event != e || info.event == e && info.c.isAssignableFrom(c)) {
                eventValues.add(i, new EventValueInfo<E, T>(e, c, g, excludeErrorMessage, excludes));
                return;
            }
            ++i;
        }
        eventValues.add(new EventValueInfo<E, T>(e, c, g, excludeErrorMessage, excludes));
    }

    public static <T, E extends Event> T getEventValue(E e, Class<T> c, int time) {
        Getter<T, ?> g = Skript.getEventValueGetter(e.getClass(), c, time);
        if (g == null) {
            return null;
        }
        return g.get(e);
    }

    public static final <T, E extends Event> Getter<? extends T, ? super E> getEventValueGetter(Class<E> e, Class<T> c, int time) {
        return Skript.getEventValueGetter(e, c, time, true);
    }

    private static final <T, E extends Event> Getter<? extends T, ? super E> getEventValueGetter(Class<E> e, final Class<T> c, int time, boolean allowDefault) {
        List<EventValueInfo<?, ?>> eventValues = Skript.getEventValuesList(time);
        for (final EventValueInfo<?, ?> ev : eventValues) {
            if (!ev.event.isAssignableFrom(e) || !c.isAssignableFrom(ev.c)) continue;
            if (!Skript.checkExcludes(ev, e, true)) {
                return null;
            }
            return ev.getter;
        }
        for (final EventValueInfo<?, ?> ev : eventValues) {
            if (!ev.event.isAssignableFrom(e) || !ev.c.isAssignableFrom(c)) continue;
            if (!Skript.checkExcludes(ev, e, true)) {
                return null;
            }
            return new Getter<T, E>(){

                @Override
                public T get(E e) {
                    Object o = ev.getter.get(e);
                    if (c.isInstance(o)) {
                        return o;
                    }
                    return null;
                }
            };
        }
        for (final EventValueInfo<?, ?> ev : eventValues) {
            if (!ev.event.isAssignableFrom(e)) continue;
            if (!Skript.checkExcludes(ev, e, true)) {
                return null;
            }
            Getter<T, ?> g = Skript.getConvertedGetter(ev, c);
            if (g == null) continue;
            return g;
        }
        if (allowDefault && time != 0) {
            return Skript.getEventValueGetter(e, c, 0);
        }
        return null;
    }

    private static final boolean checkExcludes(EventValueInfo<?, ?> ev, Class<? extends Event> e, boolean printError) {
        if (ev.exculdes == null) {
            return true;
        }
        Class<? extends E>[] classArray = ev.exculdes;
        int n = ev.exculdes.length;
        int n2 = 0;
        while (n2 < n) {
            Class ex = classArray[n2];
            if (ex.isAssignableFrom(e)) {
                if (printError) {
                    Skript.error(ev.excludeErrorMessage);
                }
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static final <E extends Event, F, T> Getter<? extends T, ? super E> getConvertedGetter(final EventValueInfo<E, F> i, Class<T> to) {
        final Converter c = Skript.getConverter(i.c, to);
        if (c == null) {
            return null;
        }
        return new Getter<T, E>(){

            @Override
            public T get(E e) {
                Object f = i.getter.get(e);
                if (f == null) {
                    return null;
                }
                return c.convert(f);
            }
        };
    }

    public static final boolean doesEventValueHaveTimeStates(Class<? extends Event> e, Class<?> c) {
        return Skript.getEventValueGetter(e, c, -1, false) != null || Skript.getEventValueGetter(e, c, 1, false) != null;
    }

    public static final boolean dispatchCommand(CommandSender sender, String command) {
        if (sender instanceof Player) {
            PlayerCommandPreprocessEvent e = new PlayerCommandPreprocessEvent((Player)sender, "/" + command);
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.isCancelled() || !e.getMessage().startsWith("/")) {
                return false;
            }
            return Bukkit.dispatchCommand((CommandSender)e.getPlayer(), (String)e.getMessage().substring(1));
        }
        ServerCommandEvent e = new ServerCommandEvent(sender, command);
        Bukkit.getPluginManager().callEvent((Event)e);
        if (e.getCommand() == null || e.getCommand().isEmpty()) {
            return false;
        }
        return Bukkit.dispatchCommand((CommandSender)e.getSender(), (String)e.getCommand());
    }

    public static final boolean logNormal() {
        return SkriptLogger.log(Verbosity.NORMAL);
    }

    public static final boolean logHigh() {
        return SkriptLogger.log(Verbosity.HIGH);
    }

    public static final boolean logVeryHigh() {
        return SkriptLogger.log(Verbosity.VERY_HIGH);
    }

    public static final boolean debug() {
        return SkriptLogger.debug();
    }

    public static final boolean log(Verbosity minVerb) {
        return SkriptLogger.log(minVerb);
    }

    public static void config(String info) {
        SkriptLogger.log(Level.CONFIG, info);
    }

    public static void info(String info) {
        SkriptLogger.log(Level.INFO, info);
    }

    public static void warning(String warning) {
        SkriptLogger.log(Level.WARNING, warning);
    }

    public static void error(String error) {
        SkriptLogger.log(Level.SEVERE, error);
    }

    public static final RuntimeException exception(String ... info) {
        return Skript.exception(null, info);
    }

    public static final RuntimeException exception(Throwable cause, String ... info) {
        Skript.logEx();
        Skript.logEx("Severe Error:");
        Skript.logEx(info);
        Skript.logEx();
        Skript.logEx("If you're developing an add-on for Skript this likely means you have done something wrong.");
        Skript.logEx("If you're a server admin, please go to http://dev.bukkit.org/server-mods/skript/tickets/");
        Skript.logEx("and create a new ticket with a meaningful title, copy & paste this whole error into it,");
        Skript.logEx("and please describe what you did before it happened and/or what you think caused the error.");
        Skript.logEx("If you feel like it's a trigger that's causing the error please post the trigger as well.");
        Skript.logEx("By following this guide fixing the error should be easy and done fast.");
        Skript.logEx();
        Skript.logEx("Stacktrace:");
        if (cause == null) {
            Skript.logEx("  warning: no exception given, dumping current stack trace instead");
            cause = new Exception();
        }
        Skript.logEx(cause.toString());
        StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            Skript.logEx("    at " + e.toString());
            ++n2;
        }
        Skript.logEx();
        Skript.logEx("Version Information:");
        Skript.logEx("  Skript: " + Skript.getInstance().getDescription().getVersion());
        Skript.logEx("  Bukkit: " + Bukkit.getBukkitVersion());
        Skript.logEx("  Java: " + System.getProperty("java.version"));
        Skript.logEx();
        Skript.logEx("Running CraftBukkit: " + runningCraftBukkit);
        Skript.logEx();
        Skript.logEx("Current node: " + SkriptLogger.getNode());
        Skript.logEx();
        Skript.logEx("End of Error.");
        Skript.logEx();
        RuntimeException r = new RuntimeException();
        r.setStackTrace(new StackTraceElement[0]);
        return r;
    }

    private static final void logEx() {
        Bukkit.getLogger().severe(EXCEPTION_PREFIX);
    }

    private static final void logEx(String ... lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Bukkit.getLogger().severe(EXCEPTION_PREFIX + line);
            ++n2;
        }
    }

    private void loadMainConfig() {
        try {
            File oldConfig = new File(this.getDataFolder(), "config.cfg");
            File config = new File(this.getDataFolder(), "config.sk");
            if (oldConfig.exists()) {
                if (!config.exists()) {
                    oldConfig.renameTo(config);
                    Skript.info("[1.3] Renamed your 'config.cfg' to 'config.sk' to match the new format");
                } else {
                    Skript.error("Found both a new and an old config, ingoring the old one");
                }
            }
            if (!config.exists()) {
                Skript.error("Config file 'config.sk' does not exist! Please make sure that you downloaded the .zip file (and not the .jar) from Skript's BukkitDev page and extracted it correctly.");
                return;
            }
            if (!config.canRead()) {
                Skript.error("Config file 'config.sk' cannot be read!");
                return;
            }
            mainConfig = new Config(config, false, true, "=");
            final ArrayList aliasNodes = new ArrayList();
            new SectionValidator().addNode("verbosity", new EnumEntryValidator<Verbosity>(Verbosity.class, new Setter<Verbosity>(){

                @Override
                public void set(Verbosity v) {
                    SkriptLogger.setVerbosity(v);
                }
            }), false).addNode("plugin priority", new EnumEntryValidator<EventPriority>(EventPriority.class, new Setter<EventPriority>(){

                @Override
                public void set(EventPriority p) {
                    defaultEventPriority = p;
                }
            }, "lowest, low, normal, high, highest"), false).addEntry("aliases", new Setter<String>(){

                @Override
                public void set(String s) {
                    String[] stringArray = s.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String n3 = stringArray[n2];
                        aliasNodes.add(n3.trim());
                        ++n2;
                    }
                }
            }, false).addEntry("keep configs loaded", Boolean.class, new Setter<Boolean>(){

                @Override
                public void set(Boolean b) {
                    keepConfigsLoaded = b;
                }
            }, true).addEntry("enable effect commands", Boolean.class, new Setter<Boolean>(){

                @Override
                public void set(Boolean b) {
                    enableEffectCommands = b;
                }
            }, false).addEntry("effect command token", new Setter<String>(){

                @Override
                public void set(String s) {
                    if (s.startsWith("/")) {
                        Skript.error("Cannot use a token that starts with a slash because it can conflict with commands");
                    } else {
                        effectCommandToken = s;
                    }
                }
            }, false).addEntry("date format", new Setter<String>(){

                @Override
                public void set(String s) {
                    try {
                        if (!s.equalsIgnoreCase("default")) {
                            Skript.dateFormat = new SimpleDateFormat(s);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Skript.error("'" + s + "' is not a valid date format. Please refer to http://docs.oracle.com/javase/6/docs/api/java/text/SimpleDateFormat.html for instructions on the format.");
                    }
                }
            }, true).addEntry("disable variable conflict warnings", Boolean.class, new Setter<Boolean>(){

                @Override
                public void set(Boolean b) {
                    disableVariableConflictWarnings = b;
                }
            }, true).addEntry("language", new Setter<String>(){

                @Override
                public void set(String s) {
                    if (!Language.load(s)) {
                        Skript.error("No language file found for '" + s + "'!");
                    }
                }
            }, true).setAllowUndefinedSections(true).validate(mainConfig.getMainNode());
            for (Node node : mainConfig.getMainNode()) {
                if (!(node instanceof SectionNode) || aliasNodes.contains(node.getName())) continue;
                Skript.error("Invalid section '" + node.getName() + "'. If this is an alias section add it to 'aliases' so it will be loaded.");
            }
            HashMap<String, HashMap<String, ItemType>> variations = new HashMap<String, HashMap<String, ItemType>>();
            int num = 0;
            for (String an : aliasNodes) {
                Node node = mainConfig.getMainNode().get(an);
                SkriptLogger.setNode(node);
                if (node == null) {
                    Skript.error("alias section '" + an + "' not found!");
                    continue;
                }
                if (!(node instanceof SectionNode)) {
                    Skript.error("aliases have to be in sections, but '" + an + "' is not a section!");
                    continue;
                }
                int i = 0;
                for (Node n : (SectionNode)node) {
                    if (n instanceof EntryNode) {
                        i += Aliases.addAliases(((EntryNode)n).getKey(), ((EntryNode)n).getValue(), variations);
                        continue;
                    }
                    if (!(n instanceof SectionNode)) continue;
                    if (!n.getName().startsWith("{") || !n.getName().endsWith("}")) {
                        Skript.error("unexpected non-variation section");
                        continue;
                    }
                    HashMap<String, ItemType> vs = new HashMap<String, ItemType>();
                    for (Node a : (SectionNode)n) {
                        if (a instanceof SectionNode) {
                            Skript.error("unexpected section");
                            continue;
                        }
                        ItemType t = Aliases.parseAlias(((EntryNode)a).getValue());
                        if (t == null) continue;
                        vs.put(((EntryNode)a).getKey(), t);
                    }
                    variations.put(n.getName().substring(1, n.getName().length() - 1), vs);
                }
                if (Skript.logHigh()) {
                    Skript.info("loaded " + i + " alias" + (i == 1 ? "" : "es") + " from " + node.getName());
                }
                num += i;
            }
            SkriptLogger.setNode(null);
            if (!keepConfigsLoaded) {
                mainConfig = null;
            }
            if (Skript.log(Verbosity.NORMAL)) {
                Skript.info("loaded a total of " + num + " aliases");
            }
            Aliases.addMissingMaterialNames();
        }
        catch (Exception e) {
            Skript.exception(e, "error loading config");
        }
    }

    public static String getSyntaxElementName(Class<? extends SyntaxElement> c) {
        if (Condition.class.isAssignableFrom(c)) {
            return "condition";
        }
        if (Effect.class.isAssignableFrom(c)) {
            return "effect";
        }
        if (Variable.class.isAssignableFrom(c)) {
            return "variable";
        }
        if (Expression.class.isAssignableFrom(c)) {
            return "expression";
        }
        return "syntax element";
    }

    static final class EventValueInfo<E extends Event, T> {
        final Class<E> event;
        final Class<T> c;
        final Getter<T, E> getter;
        final Class<? extends E>[] exculdes;
        final String excludeErrorMessage;

        public EventValueInfo(Class<E> event, Class<T> c, Getter<T, E> getter) {
            Validate.notNull(event, c, getter);
            this.event = event;
            this.c = c;
            this.getter = getter;
            this.exculdes = null;
            this.excludeErrorMessage = null;
        }

        public EventValueInfo(Class<E> event, Class<T> c, Getter<T, E> getter, String excludeErrorMessage, Class<? extends E>[] exculdes) {
            Validate.notNull(event, c, getter);
            this.event = event;
            this.c = c;
            this.getter = getter;
            this.exculdes = exculdes;
            this.excludeErrorMessage = excludeErrorMessage;
        }
    }

    public static enum ExpressionType {
        SIMPLE,
        NORMAL,
        COMBINED,
        PROPERTY;

    }
}

