/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.World;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.weather.WeatherEvent;

public final class WeatherType
extends Enum<WeatherType> {
    public static final /* enum */ WeatherType CLEAR = new WeatherType("clear", "sun", "sunny");
    public static final /* enum */ WeatherType RAIN = new WeatherType("rain", "rainy", "raining");
    public static final /* enum */ WeatherType THUNDER = new WeatherType("thunder", "thundering", "thunderstorm");
    private final String[] names;
    private static final Map<String, WeatherType> byName;
    private static final /* synthetic */ WeatherType[] ENUM$VALUES;

    static {
        ENUM$VALUES = new WeatherType[]{CLEAR, RAIN, THUNDER};
        byName = new HashMap<String, WeatherType>();
        WeatherType[] weatherTypeArray = WeatherType.values();
        int n = weatherTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            WeatherType t = weatherTypeArray[n2];
            String[] stringArray = t.names;
            int n3 = t.names.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray[n4];
                byName.put(name, t);
                ++n4;
            }
            ++n2;
        }
    }

    private WeatherType(String ... names) {
        this.names = names;
    }

    public static final WeatherType parse(String s) {
        return byName.get(s);
    }

    public static WeatherType fromWorld(World world) {
        Validate.notNull((Object)world, (String)"world");
        if (world.isThundering()) {
            return THUNDER;
        }
        if (world.hasStorm()) {
            return RAIN;
        }
        return CLEAR;
    }

    public static WeatherType fromEvent(WeatherEvent e) {
        if (e instanceof WeatherChangeEvent) {
            return WeatherType.fromEvent((WeatherChangeEvent)e);
        }
        if (e instanceof ThunderChangeEvent) {
            return WeatherType.fromEvent((ThunderChangeEvent)e);
        }
        assert (false);
        return null;
    }

    public static WeatherType fromEvent(WeatherChangeEvent e) {
        Validate.notNull((Object)e, (String)"e");
        if (!e.toWeatherState()) {
            return CLEAR;
        }
        if (e.getWorld().isThundering()) {
            return THUNDER;
        }
        return RAIN;
    }

    public static WeatherType fromEvent(ThunderChangeEvent e) {
        Validate.notNull((Object)e, (String)"e");
        if (e.toThunderState()) {
            return THUNDER;
        }
        if (e.getWorld().hasStorm()) {
            return RAIN;
        }
        return CLEAR;
    }

    public String toString() {
        return this.names[0];
    }

    public String adjective() {
        switch (this) {
            case CLEAR: {
                return "sunny";
            }
            case RAIN: {
                return "raining";
            }
            case THUNDER: {
                return "thundering";
            }
        }
        assert (false);
        return null;
    }

    public boolean isWeather(World w) {
        return this.isWeather(w.hasStorm(), w.isThundering());
    }

    public boolean isWeather(boolean rain, boolean thunder) {
        switch (this) {
            case CLEAR: {
                return !thunder && !rain;
            }
            case RAIN: {
                return !thunder && rain;
            }
            case THUNDER: {
                return thunder && rain;
            }
        }
        assert (false);
        return false;
    }

    public void setWeather(World w) {
        if (w.isThundering() != (this == THUNDER)) {
            w.setThundering(this == THUNDER);
        }
        if (w.hasStorm() != (this != CLEAR)) {
            w.setStorm(this != CLEAR);
        }
    }

    public static WeatherType[] values() {
        WeatherType[] weatherTypeArray = ENUM$VALUES;
        int n = weatherTypeArray.length;
        WeatherType[] weatherTypeArray2 = new WeatherType[n];
        System.arraycopy(ENUM$VALUES, 0, weatherTypeArray2, 0, n);
        return weatherTypeArray2;
    }

    public static WeatherType valueOf(String string) {
        return Enum.valueOf(WeatherType.class, string);
    }
}

