/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.util;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.util.ConvertedExpression;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import org.bukkit.event.Event;

public class ConvertedLiteral<F, T>
extends ConvertedExpression<F, T>
implements Literal<T> {
    private final T[] data;

    public ConvertedLiteral(Literal<F> source, T[] data, Class<T> to) {
        super(source, to, null);
        this.data = data;
    }

    @Override
    public <R> Literal<? extends R> getConvertedExpression(Class<R> to) {
        if (to.isAssignableFrom(this.to)) {
            return this;
        }
        return ((Literal)this.source).getConvertedExpression(to);
    }

    @Override
    public String toString(Event e, boolean debug) {
        return Skript.toString(this.data, this.getAnd());
    }

    @Override
    public T[] getArray() {
        return this.data;
    }

    @Override
    public T[] getAll() {
        return this.data;
    }

    @Override
    public T[] getArray(Event e) {
        return this.getArray();
    }

    @Override
    public T getSingle() {
        if (this.getAnd() && this.data.length > 1) {
            throw new SkriptAPIException("Call to getSingle on a non-single expression");
        }
        return Utils.getRandom(this.data);
    }

    @Override
    public T getSingle(Event e) {
        return this.getSingle();
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check(this.data, c, false, this.getAnd());
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, Condition cond) {
        return SimpleExpression.check(this.data, c, cond.isNegated(), this.getAnd());
    }
}

