/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.SkriptCommand;
import ch.njol.skript.command.SkriptCommandEvent;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.VariableString;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import ch.njol.util.Validate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SkriptParser {
    private final String expr;
    private final boolean parseStatic;
    private String bestError = null;
    private int bestErrorQuality = 0;
    public final ParseContext context;
    public static final String wildcard = "[^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?";
    public static final String stringMatcher = "\"[^\"]*?(?:\"\"[^\"]*)*?\"";
    private static final Pattern varPattern = Pattern.compile("^(?i)((the )?var(iable)? )?\\{([^{}]|%\\{|\\}%)+\\}$");

    private final void setBestError(ErrorQuality quality, String error, boolean appendCurrentNodeSuffix) {
        if (this.bestErrorQuality < quality.quality()) {
            this.bestError = appendCurrentNodeSuffix ? String.valueOf(error) + SkriptLogger.getCurrentNodeSuffix() : error;
            this.bestErrorQuality = quality.quality();
        }
    }

    private final void setBestError(SkriptParser other) {
        if (this.bestErrorQuality < other.bestErrorQuality) {
            this.bestError = other.bestError;
            this.bestErrorQuality = other.bestErrorQuality;
        }
    }

    private SkriptParser(String expr) {
        this(expr, false);
    }

    private SkriptParser(String expr, boolean parseStatic) {
        this(expr, parseStatic, ParseContext.DEFAULT);
    }

    private SkriptParser(String expr, boolean parseStatic, ParseContext context) {
        Validate.notNull((Object)expr, "expr");
        this.expr = expr;
        this.parseStatic = parseStatic;
        this.context = context;
    }

    public static final <T> Literal<? extends T> parseLiteral(String expr, Class<T> c, ParseContext context) {
        if ((expr = expr.trim()).isEmpty()) {
            return null;
        }
        return new UnparsedLiteral(expr).getConvertedExpression(c, context);
    }

    public static final SyntaxElement parse(String expr, Iterator<? extends SyntaxElementInfo<?>> source, boolean parseLiteral, boolean parseVariable, String defaultError) {
        if ((expr = expr.trim()).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        Variable<Object> var = SkriptParser.parseVariable(expr, Object.class);
        if (var != null) {
            if (parseVariable) {
                return var;
            }
            Skript.error(defaultError);
            return null;
        }
        SkriptLogger.SubLog log = SkriptLogger.startSubLog();
        Object e = SkriptParser.parse(expr, source, null);
        SkriptLogger.stopSubLog(log);
        if (e != null) {
            log.printLog();
            return e;
        }
        if (parseLiteral) {
            return new UnparsedLiteral(expr);
        }
        log.printErrors(defaultError);
        return null;
    }

    public static final <T extends SyntaxElement> T parse(String expr, Iterator<? extends SyntaxElementInfo<T>> source, String defaultError) {
        if ((expr = expr.trim()).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        SkriptLogger.SubLog log = SkriptLogger.startSubLog();
        T e = new SkriptParser(expr).parse(source);
        SkriptLogger.stopSubLog(log);
        if (e != null) {
            log.printLog();
            return e;
        }
        log.printErrors(defaultError);
        return null;
    }

    public static final <T extends SyntaxElement> T parseStatic(String expr, Iterator<? extends SyntaxElementInfo<? extends T>> source, String defaultError) {
        if ((expr = expr.trim()).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        SkriptLogger.SubLog log = SkriptLogger.startSubLog();
        T e = new SkriptParser(expr, true).parse(source);
        SkriptLogger.stopSubLog(log);
        if (e != null) {
            log.printLog();
            return e;
        }
        log.printErrors(defaultError);
        return null;
    }

    private final <T extends SyntaxElement> T parse(Iterator<? extends SyntaxElementInfo<? extends T>> source) {
        while (source.hasNext()) {
            SyntaxElementInfo<? extends T> info = source.next();
            int i = 0;
            while (i < info.patterns.length) {
                block13: {
                    try {
                        ParseResult res = this.parse_i(info.patterns[i], 0, 0);
                        if (res == null) break block13;
                        int x = -1;
                        int j = 0;
                        while ((x = SkriptParser.next(info.patterns[i], '%', x + 1)) != -1) {
                            String name;
                            int x2 = SkriptParser.next(info.patterns[i], '%', x + 1);
                            if (res.vars[j] == null && !(name = info.patterns[i].substring(x + 1, x2)).startsWith("-")) {
                                VarInfo vi = SkriptParser.getVarInfo(name);
                                DefaultExpression<?> var = vi.classes[0].getDefaultExpression();
                                if (var == null) {
                                    throw new SkriptAPIException("The class '" + vi.classes[0].getName() + "' does not provide a default expression. Either allow null (with %-" + vi.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (!vi.isPlural[0] && !var.isSingle()) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getName() + "' is not a single-element expression. Change your pattern to allow multiple elements or make the expression mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (vi.time != 0 && !var.setTime(vi.time)) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getName() + "' does not have distinct time states. Either allow null (with %-" + vi.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                var.init();
                                res.vars[j] = var;
                            }
                            x = x2;
                            ++j;
                        }
                        SyntaxElement e = (SyntaxElement)info.c.newInstance();
                        SkriptLogger.SubLog log = SkriptLogger.startSubLog();
                        if (!e.init(res.vars, i, ScriptLoader.hasDelayBefore, res)) {
                            SkriptLogger.stopSubLog(log);
                            if (log.hasErrors()) {
                                this.setBestError(ErrorQuality.SEMANTIC_ERROR, log.getLastError(), false);
                            }
                            break block13;
                        }
                        SkriptLogger.stopSubLog(log);
                        log.printLog();
                        return (T)e;
                    }
                    catch (InstantiationException e) {
                        SkriptAPIException.instantiationException("the " + Skript.getSyntaxElementName(info.c), info.c, e);
                    }
                    catch (IllegalAccessException e) {
                        SkriptAPIException.inaccessibleConstructor(info.c, e);
                    }
                }
                ++i;
            }
        }
        if (this.bestError != null) {
            SkriptLogger.logDirect(Level.SEVERE, this.bestError);
        }
        return null;
    }

    private static final <T> Variable<T> parseVariable(String expr, Class<T> returnType) {
        if (varPattern.matcher(expr).matches()) {
            VariableString vs = VariableString.newInstance(expr.substring(expr.indexOf(123) + 1, expr.lastIndexOf(125)), StringMode.VARIABLE_NAME);
            if (vs == null) {
                return null;
            }
            return new Variable<T>(vs, returnType);
        }
        return null;
    }

    private final <T> Expression<? extends T> parseExpr(Class<T> returnType, String expr, boolean literalOnly) {
        SkriptLogger.SubLog log;
        if (expr.isEmpty()) {
            return null;
        }
        if (!literalOnly) {
            Variable<T> var = SkriptParser.parseVariable(expr, returnType);
            if (var != null) {
                return var;
            }
            log = SkriptLogger.startSubLog();
            SkriptParser parser = new SkriptParser(expr);
            Expression v = (Expression)parser.parse(Skript.getExpressions().iterator());
            SkriptLogger.stopSubLog(log);
            if (v != null) {
                Expression<T> w = v.getConvertedExpression(returnType);
                if (w == null) {
                    this.setBestError(ErrorQuality.EXPRESSION_OF_WRONG_TYPE, String.valueOf(v.toString()) + " " + (v.isSingle() ? "is" : "are") + " not " + Utils.a(Skript.getExactClassName(returnType)), true);
                }
                return w;
            }
            this.setBestError(parser);
        }
        UnparsedLiteral l = new UnparsedLiteral(expr);
        if (returnType == Object.class) {
            return l;
        }
        log = SkriptLogger.startSubLog();
        Literal<T> p = l.getConvertedExpression(returnType, this.context);
        SkriptLogger.stopSubLog(log);
        if (p == null) {
            this.setBestError(ErrorQuality.NOT_AN_EXPRESSION, log.getLastError() == null ? "'" + expr + "' is not " + Utils.a(Skript.getExactClassName(returnType)) : log.getLastError(), log.getLastError() == null);
        }
        return p;
    }

    public static Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parseEvent(String event, String defaultError) {
        SkriptLogger.SubLog log = SkriptLogger.startSubLog();
        Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> e = new SkriptParser(event, true, ParseContext.EVENT).parseEvent();
        SkriptLogger.stopSubLog(log);
        if (e != null) {
            log.printLog();
            return e;
        }
        log.printErrors(defaultError);
        return null;
    }

    public static boolean parseArguments(String args, SkriptCommand command, SkriptCommandEvent event) {
        SkriptParser parser = new SkriptParser(args, true, ParseContext.COMMAND);
        ParseResult res = parser.parse_i(command.getPattern(), 0, 0);
        if (res == null) {
            if (parser.bestError != null) {
                SkriptLogger.logDirect(Level.SEVERE, parser.bestError);
            }
            return false;
        }
        List<Argument<?>> as = command.getArguments();
        assert (as.size() == res.vars.length);
        int i = 0;
        while (i < res.vars.length) {
            if (res.vars[i] == null) {
                as.get(i).setToDefault(event);
            } else {
                as.get(i).set(event, res.vars[i].getArray(event));
            }
            ++i;
        }
        return true;
    }

    private Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parseEvent() {
        for (SkriptEvent.SkriptEventInfo<?> info : Skript.getEvents()) {
            int i = 0;
            while (i < info.patterns.length) {
                try {
                    ParseResult res = this.parse_i(info.patterns[i], 0, 0);
                    if (res != null) {
                        SkriptEvent e = (SkriptEvent)info.c.newInstance();
                        e.init((Literal[])Arrays.copyOf(res.vars, res.vars.length, Literal[].class), i, res);
                        return new Pair(info, e);
                    }
                }
                catch (InstantiationException e) {
                    SkriptAPIException.instantiationException("the event", info.c, e);
                }
                catch (IllegalAccessException e) {
                    SkriptAPIException.inaccessibleConstructor(info.c, e);
                }
                ++i;
            }
        }
        if (this.bestError != null) {
            SkriptLogger.logDirect(Level.SEVERE, this.bestError);
        }
        return null;
    }

    private static int nextBracket(String s, char closingBracket, char openingBracket, int start) {
        int n = 0;
        int i = start;
        while (i < s.length()) {
            if (s.charAt(i) == '\\') {
                ++i;
            } else if (s.charAt(i) == closingBracket) {
                if (n == 0) {
                    return i;
                }
                --n;
            } else if (s.charAt(i) == openingBracket) {
                ++n;
            }
            ++i;
        }
        throw new MalformedPatternException(s, "missing closing bracket '" + closingBracket + "'");
    }

    private static int next(String s, char c, int from) {
        int i = from;
        while (i < s.length()) {
            if (s.charAt(i) == '\\') {
                ++i;
            } else if (s.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int nextQuote(String s, int from) {
        int i = from;
        while (i < s.length()) {
            if (s.charAt(i) == '\"') {
                if (i == s.length() - 1 || s.charAt(i + 1) != '\"') {
                    return i;
                }
                ++i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean hasOnly(String s, String chars, int start, int end) {
        int i = start;
        while (i < end) {
            if (chars.indexOf(s.charAt(i)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final ParseResult parse_i(String pattern, int i, int j) {
        int matchedChars = 0;
        while (j < pattern.length()) {
            switch (pattern.charAt(j)) {
                case '[': {
                    ParseResult res = this.parse_i(pattern, i, j + 1);
                    if (res != null) {
                        return res;
                    }
                    int end = SkriptParser.nextBracket(pattern, ']', '[', j + 1);
                    if ((SkriptParser.hasOnly(pattern, "[(", 0, j) || pattern.charAt(j - 1) == ' ') && end < pattern.length() - 1 && pattern.charAt(end + 1) == ' ') {
                        ++end;
                    }
                    j = end + 1;
                    break;
                }
                case '(': {
                    ParseResult res;
                    int end = SkriptParser.nextBracket(pattern, ')', '(', j + 1);
                    String[] gs = pattern.substring(j + 1, end).split("\\|");
                    int j2 = j + 1;
                    int k = 0;
                    while (k < gs.length) {
                        res = this.parse_i(pattern, i, j2);
                        if (res != null) {
                            return res;
                        }
                        j2 += gs[k].length() + 1;
                        ++k;
                    }
                    return null;
                }
                case '%': {
                    int i2;
                    ParseResult res;
                    if (i == this.expr.length()) {
                        return null;
                    }
                    int end = SkriptParser.next(pattern, '%', j + 1);
                    if (end == -1) {
                        throw new MalformedPatternException(pattern, "odd number of '%'");
                    }
                    String name = pattern.substring(j + 1, end);
                    VarInfo vi = SkriptParser.getVarInfo(name);
                    if (end == pattern.length() - 1) {
                        i2 = this.expr.length();
                    } else if (this.expr.charAt(i) == '\"') {
                        i2 = SkriptParser.nextQuote(this.expr, i + 1) + 1;
                        if (i2 == 0) {
                            return null;
                        }
                    } else if (this.expr.charAt(i) == '{') {
                        i2 = this.expr.indexOf(125, i + 1) + 1;
                        if (i2 == 0) {
                            return null;
                        }
                    } else {
                        i2 = i + 1;
                    }
                    while (i2 <= this.expr.length()) {
                        if (i2 < this.expr.length() && (this.expr.charAt(i2) == '\"' ? (i2 = SkriptParser.nextQuote(this.expr, i2 + 1) + 1) == 0 : this.expr.charAt(i2) == '{' && (i2 = this.expr.indexOf(125, i2 + 1) + 1) == 0)) {
                            return null;
                        }
                        res = this.parse_i(pattern, i2, end + 1);
                        if (res != null) {
                            int k = 0;
                            while (k < vi.classes.length) {
                                Expression<?> var = this.parseExpr(vi.classes[k].getC(), this.expr.substring(i, i2), this.parseStatic);
                                if (var != null) {
                                    if (!(vi.isPlural[k] || var instanceof UnparsedLiteral || var.isSingle())) {
                                        if (this.context == ParseContext.COMMAND) {
                                            this.setBestError(ErrorQuality.SEMANTIC_ERROR, "this command can only accept a single " + vi.classes[k].getName() + "!", false);
                                        } else {
                                            this.setBestError(ErrorQuality.SEMANTIC_ERROR, "this expression can only accept a single " + vi.classes[k].getName() + ", but multiple are given.", true);
                                        }
                                        return null;
                                    }
                                    if (vi.time != 0) {
                                        if (var instanceof UnparsedLiteral) {
                                            return null;
                                        }
                                        if (ScriptLoader.hasDelayBefore == 1) {
                                            this.setBestError(ErrorQuality.SEMANTIC_ERROR, "Cannot use time states after the event has already passed", true);
                                            return null;
                                        }
                                        if (!var.setTime(vi.time)) {
                                            this.setBestError(ErrorQuality.SEMANTIC_ERROR, var + " does not have a " + (vi.time == -1 ? "past" : "future") + " state", true);
                                            return null;
                                        }
                                    }
                                    res.vars[StringUtils.count((String)pattern, (char)'%', (int)0, (int)(j - 1)) / 2] = var;
                                    return res;
                                }
                                ++k;
                            }
                            if (res.matchedChars + matchedChars >= 5) {
                                String types;
                                if (vi.classes.length == 1) {
                                    types = Utils.a(vi.classes[0].getName());
                                } else {
                                    StringBuilder b = new StringBuilder("neither ");
                                    int k2 = 0;
                                    while (k2 < vi.classes.length) {
                                        if (k2 != 0) {
                                            if (k2 != vi.classes.length - 1) {
                                                b.append(", ");
                                            } else {
                                                b.append(" nor ");
                                            }
                                        }
                                        b.append(Utils.a(vi.classes[k2].getName()));
                                        ++k2;
                                    }
                                    types = b.toString();
                                }
                                this.setBestError(ErrorQuality.NOT_AN_EXPRESSION, "'" + this.expr.substring(i, i2) + "' is not " + types, true);
                            }
                        }
                        ++i2;
                    }
                    return null;
                }
                case '<': {
                    ParseResult res;
                    int end = pattern.indexOf(62, j + 1);
                    if (end == -1) {
                        throw new MalformedPatternException(pattern, "missing closing regex bracket '>'");
                    }
                    int i2 = i + 1;
                    while (i2 <= this.expr.length()) {
                        Matcher m;
                        res = this.parse_i(pattern, i2, end + 1);
                        if (res != null && (m = Pattern.compile(pattern.substring(j + 1, end)).matcher(this.expr.substring(i, i2))).matches()) {
                            res.regexes.add(0, m.toMatchResult());
                            return res;
                        }
                        ++i2;
                    }
                    return null;
                }
                case ')': 
                case ']': {
                    ++j;
                    break;
                }
                case '|': {
                    j = SkriptParser.nextBracket(pattern, ')', '(', j + 1) + 1;
                    break;
                }
                case ' ': {
                    if (i == this.expr.length() || i > 0 && this.expr.charAt(i - 1) == ' ') {
                        ++j;
                        break;
                    }
                    if (this.expr.charAt(i) != ' ') {
                        return null;
                    }
                    ++matchedChars;
                    ++i;
                    ++j;
                    break;
                }
                case '\\': {
                    if (++j == pattern.length()) {
                        throw new MalformedPatternException(pattern, "must not end with a backslash");
                    }
                }
                default: {
                    if (i == this.expr.length() || Character.toLowerCase(pattern.charAt(j)) != Character.toLowerCase(this.expr.charAt(i))) {
                        return null;
                    }
                    ++matchedChars;
                    ++i;
                    ++j;
                }
            }
        }
        if (i == this.expr.length() && j == pattern.length()) {
            return new ParseResult(this.expr, pattern, matchedChars);
        }
        return null;
    }

    private static VarInfo getVarInfo(String s) throws MalformedPatternException {
        int a;
        VarInfo r = new VarInfo();
        r.isOptional = s.startsWith("-");
        if (r.isOptional) {
            s = s.substring(1);
        }
        if ((a = s.indexOf("@")) != -1) {
            r.time = Integer.parseInt(s.substring(a + 1));
            s = s.substring(0, a);
        }
        String[] classes = s.split("/");
        r.classes = new ClassInfo[classes.length];
        r.isPlural = new boolean[classes.length];
        int i = 0;
        while (i < classes.length) {
            Pair<String, Boolean> p = Utils.getPlural(classes[i]);
            r.classes[i] = Skript.getClassInfo((String)p.first);
            r.isPlural[i] = (Boolean)p.second;
            if (r.classes[i] == null) {
                throw new MalformedPatternException(s, "invalid class '" + (String)p.first + "'");
            }
            ++i;
        }
        return r;
    }

    private static enum ErrorQuality {
        NONE,
        NOT_AN_EXPRESSION,
        EXPRESSION_OF_WRONG_TYPE,
        SEMANTIC_ERROR;


        int quality() {
            return this.ordinal();
        }
    }

    private static final class MalformedPatternException
    extends RuntimeException {
        private static final long serialVersionUID = -2479399963189481643L;

        public MalformedPatternException(String pattern, String message) {
            super(String.valueOf(message) + " [pattern: " + pattern + "]");
        }
    }

    public static final class ParseResult {
        public final Expression<?>[] vars;
        public final List<MatchResult> regexes = new ArrayList<MatchResult>();
        public final String expr;
        int matchedChars = 0;

        public ParseResult(String expr, String pattern, int matchedChars) {
            this.expr = expr;
            this.vars = new Expression[StringUtils.count(pattern, '%') / 2];
            this.matchedChars = matchedChars;
        }
    }

    private static final class VarInfo {
        ClassInfo<?>[] classes;
        boolean isOptional;
        boolean[] isPlural;
        int time = 0;

        private VarInfo() {
        }
    }
}

