/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.base;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.event.Event;

public abstract class SimplePropertyExpression<F, T>
extends PropertyExpression<F, T> {
    private final Class<T> returnType;
    private final String propertyName;
    private final Converter<? super F, ? extends T> converter;

    protected static <T> void register(Class<? extends SimplePropertyExpression<?, T>> c, Class<T> type, String property, String fromType) {
        Skript.registerExpression(c, type, Skript.ExpressionType.PROPERTY, "[the] " + property + " of %" + fromType + "%", "%" + fromType + "%'[s] " + property);
    }

    public SimplePropertyExpression(Class<T> returnType, String propertyName, Converter<? super F, ? extends T> converter) {
        this.returnType = returnType;
        this.propertyName = propertyName;
        this.converter = converter;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    @Override
    public Class<T> getReturnType() {
        return this.returnType;
    }

    @Override
    protected T[] get(Event e, F[] source) {
        return super.get(source, this.converter);
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the " + this.propertyName + " of " + this.getExpr().toString(e, debug);
    }
}

