/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;

public class ExprSignText
extends SimpleExpression<String> {
    private int line;
    private Expression<Block> block;

    static {
        Skript.registerExpression(ExprSignText.class, String.class, Skript.ExpressionType.PROPERTY, "[the] line <[1-4]> [of %block%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.line = Integer.parseInt(parseResult.regexes.get(0).group());
        this.block = exprs[0];
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "line " + this.line + " of " + this.block.toString(e, debug);
    }

    protected String[] get(Event e) {
        if (this.getTime() >= 0 && this.block.isDefault() && e instanceof SignChangeEvent && !Delay.isDelayed(e)) {
            return new String[]{((SignChangeEvent)e).getLine(this.line - 1)};
        }
        Block b = this.block.getSingle(e);
        if (b == null) {
            return null;
        }
        if (b.getType() != Material.SIGN_POST && b.getType() != Material.WALL_SIGN) {
            return null;
        }
        return new String[]{((Sign)b.getState()).getLine(this.line - 1)};
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.CLEAR) {
            return Object.class;
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        if (this.getTime() >= 0 && this.block.isDefault() && e instanceof SignChangeEvent && !Delay.isDelayed(e)) {
            switch (mode) {
                case CLEAR: {
                    ((SignChangeEvent)e).setLine(this.line - 1, "");
                }
            }
        }
        switch (mode) {
            case CLEAR: {
                Block b = this.block.getSingle(e);
                if (b == null) {
                    return;
                }
                if (b.getType() != Material.SIGN_POST && b.getType() != Material.WALL_SIGN) {
                    return;
                }
                ((Sign)b.getState()).setLine(this.line - 1, "");
            }
        }
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, SignChangeEvent.class, this.block);
    }
}

