/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import ch.njol.util.iterator.ArrayIterator;
import ch.njol.util.iterator.CheckedIterator;
import ch.njol.util.iterator.IteratorIterable;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprItems
extends SimpleExpression<ItemStack> {
    private Expression<ItemType> types = null;
    private boolean blocks = false;
    private ItemStack[] buffer = null;

    static {
        Skript.registerExpression(ExprItems.class, ItemStack.class, Skript.ExpressionType.NORMAL, "[(all|every)] item(s|[ ]types)", "items of type[s] %itemtypes%", "[(all|every)] block(s|[ ]types)", "blocks of type[s] %itemtypes%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        if (vars.length > 0) {
            this.types = vars[0];
        }
        boolean bl = this.blocks = matchedPattern >= 2;
        if (this.types instanceof Literal) {
            ItemType[] itemTypeArray = (ItemType[])((Literal)this.types).getAll();
            int n = itemTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemType t = itemTypeArray[n2];
                t.setAll(true);
                ++n2;
            }
        }
        return true;
    }

    protected ItemStack[] get(Event e) {
        if (this.buffer != null) {
            return this.buffer;
        }
        ArrayList<ItemStack> r = new ArrayList<ItemStack>();
        for (ItemStack is : new IteratorIterable<ItemStack>(this.iterator(e))) {
            r.add(is);
        }
        if (this.types instanceof Literal) {
            this.buffer = r.toArray(new ItemStack[r.size()]);
            return this.buffer;
        }
        return r.toArray(new ItemStack[r.size()]);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Iterator<ItemStack> iterator(Event e) {
        Iterator<ItemStack> iter = this.types == null ? new Iterator<ItemStack>(){
            private final Iterator<Material> iter = new ArrayIterator<Material>(Material.values());

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public ItemStack next() {
                return new ItemStack(this.iter.next());
            }

            @Override
            public void remove() {
            }
        } : new Iterator<ItemStack>(e){
            private final Iterator<ItemType> iter;
            Iterator<ItemStack> current;
            {
                this.iter = new ArrayIterator<ItemType>((ItemType[])ExprItems.this.types.getArray(event));
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext() || this.current.hasNext();
            }

            @Override
            public ItemStack next() {
                if (this.current == null || !this.current.hasNext()) {
                    this.current = this.iter.next().getAll().iterator();
                }
                return this.current.next();
            }

            @Override
            public void remove() {
            }
        };
        if (!this.blocks) {
            return iter;
        }
        return new CheckedIterator<ItemStack>(iter, new Checker<ItemStack>(){

            @Override
            public boolean check(ItemStack is) {
                return is.getTypeId() <= 255;
            }
        });
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.blocks ? "blocks" : "items") + (this.types == null ? "" : " of type" + (this.types.isSingle() ? "" : "s") + " " + this.types.toString(e, debug));
    }

    @Override
    public boolean canLoop() {
        return this.types == null || !this.types.isSingle() || this.types instanceof Literal && this.types.getSingle(null).numTypes() > 1;
    }

    @Override
    public boolean isLoopOf(String s) {
        return this.blocks && s.equalsIgnoreCase("block") || !this.blocks && s.equalsIgnoreCase("item");
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

