/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Aliases;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.ItemType;
import ch.njol.util.StringUtils;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

public class ExprEntity
extends SimpleExpression<Entity> {
    private EntityData<?> type;
    private EventValueExpression<Entity> entity;

    static {
        Skript.registerExpression(ExprEntity.class, Entity.class, Skript.ExpressionType.SIMPLE, "[the] [event-]<.+>");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        SkriptLogger.SubLog log = SkriptLogger.startSubLog();
        ItemType item = Aliases.parseItemType(parseResult.regexes.get(0).group());
        if (item != null && !StringUtils.startsWithIgnoreCase(parseResult.expr, "the ")) {
            log.stop();
            return false;
        }
        log.clear();
        this.type = EntityData.parseWithoutAnOrAny(parseResult.regexes.get(0).group());
        log.stop();
        if (this.type == null || this.type.isPlural()) {
            return false;
        }
        log.printLog();
        this.entity = new EventValueExpression(this.type.getType());
        return this.entity.init();
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.type.getType();
    }

    protected Entity[] get(Event e) {
        Entity[] es = (Entity[])this.entity.getArray(e);
        if (es.length == 0 || this.type.isInstance(es[0])) {
            return es;
        }
        return null;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the " + this.type;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

