/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Patterns;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

public class ExprArithmetic
extends SimpleExpression<Number> {
    private static final Patterns<Operator> patterns = new Patterns(new Object[][]{{"%number%[ ]+[ ]%number%", Operator.PLUS}, {"%number%[ ]-[ ]%number%", Operator.MINUS}, {"%number%[ ]*[ ]%number%", Operator.MULT}, {"%number%[ ]/[ ]%number%", Operator.DIV}, {"%number%[ ]^[ ]%number%", Operator.EXP}, {"\\(%number%[ ]+[ ]%number%\\)", Operator.PLUS}, {"\\(%number%[ ]-[ ]%number%\\)", Operator.MINUS}, {"\\(%number%[ ]*[ ]%number%\\)", Operator.MULT}, {"\\(%number%[ ]/[ ]%number%\\)", Operator.DIV}, {"\\(%number%[ ]^[ ]%number%\\)", Operator.EXP}});
    private Expression<? extends Number> first;
    private Expression<? extends Number> second;
    private Operator op;
    private Class<? extends Number> returnType;
    private boolean integer;
    private Number[] one;

    static {
        Skript.registerExpression(ExprArithmetic.class, Number.class, Skript.ExpressionType.COMBINED, patterns.getPatterns());
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.first = exprs[0];
        this.second = exprs[1];
        this.op = patterns.getInfo(matchedPattern);
        if (this.op == Operator.DIV || this.op == Operator.EXP) {
            this.returnType = Double.class;
        } else {
            Class<? extends Number> f = this.first.getReturnType();
            Class<? extends Number> s = this.second.getReturnType();
            Class[] integers = new Class[]{Long.class, Integer.class, Short.class, Byte.class};
            boolean firstIsInt = false;
            boolean secondIsInt = false;
            Class[] classArray = integers;
            int n = integers.length;
            int n2 = 0;
            while (n2 < n) {
                Class i = classArray[n2];
                firstIsInt |= i.isAssignableFrom(f);
                secondIsInt |= i.isAssignableFrom(s);
                ++n2;
            }
            this.returnType = firstIsInt && secondIsInt ? Integer.class : Double.class;
        }
        this.integer = this.returnType == Integer.class;
        this.one = (Number[])Array.newInstance(this.returnType, 1);
        return true;
    }

    protected Number[] get(Event e) {
        Number n1 = this.first.getSingle(e);
        Number n2 = this.second.getSingle(e);
        if (n1 == null) {
            n1 = 0;
        }
        if (n2 == null) {
            n2 = 0;
        }
        this.one[0] = this.op.calculate(n1, n2, this.integer);
        return this.one;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "(" + this.first.toString(e, debug) + " " + (Object)((Object)this.op) + " " + this.second.toString(e, debug) + ")";
    }

    private static enum Operator {
        PLUS('+'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return n1.intValue() + n2.intValue();
                }
                return n1.doubleValue() + n2.doubleValue();
            }
        }
        ,
        MINUS('-'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return n1.intValue() - n2.intValue();
                }
                return n1.doubleValue() - n2.doubleValue();
            }
        }
        ,
        MULT('*'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return n1.intValue() * n2.intValue();
                }
                return n1.doubleValue() * n2.doubleValue();
            }
        }
        ,
        DIV('/'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return n1.intValue() / n2.intValue();
                }
                return n1.doubleValue() / n2.doubleValue();
            }
        }
        ,
        EXP('^'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return (int)Math.pow(n1.intValue(), n2.intValue());
                }
                return Math.pow(n1.doubleValue(), n2.doubleValue());
            }
        };

        public final char sign;

        private Operator(char sign) {
            this.sign = sign;
        }

        public abstract Number calculate(Number var1, Number var2, boolean var3);

        public String toString() {
            return "" + this.sign;
        }
    }
}

