/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.events.ScheduledEvent;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.util.Timespan;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class EvtPeriodical
extends SkriptEvent {
    private int period;
    private Trigger t;
    private int[] taskIDs;

    static {
        Skript.registerEvent(EvtPeriodical.class, ScheduledEvent.class, false, "every %timespan% [in [world[s]] %worlds%]");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        World[] worlds;
        this.period = ((Timespan)args[0].getSingle()).getTicks();
        World[] worldArray = worlds = args[1] == null ? null : (World[])args[1].getArray();
        if (worlds == null) {
            this.taskIDs = new int[]{Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    EvtPeriodical.this.execute(null);
                }
            }, (long)this.period, (long)this.period)};
        } else {
            this.taskIDs = new int[worlds.length];
            int i = 0;
            while (i < worlds.length) {
                final World w = worlds[i];
                this.taskIDs[i] = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Skript.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        EvtPeriodical.this.execute(w);
                    }
                }, (long)this.period - w.getFullTime() % (long)this.period, (long)this.period);
                ++i;
            }
        }
        return true;
    }

    private void execute(World w) {
        ScheduledEvent e = new ScheduledEvent(w);
        SkriptEventHandler.logEventStart(e);
        SkriptEventHandler.logTriggerStart(this.t);
        this.t.start(e);
        SkriptEventHandler.logTriggerEnd(this.t);
        SkriptEventHandler.logEventEnd();
    }

    @Override
    public void register(Trigger t) {
        this.t = t;
    }

    @Override
    public void unregister(Trigger t) {
        int[] nArray = this.taskIDs;
        int n = this.taskIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int taskID = nArray[n2];
            Bukkit.getScheduler().cancelTask(taskID);
            ++n2;
        }
    }

    @Override
    public void unregisterAll() {
        int[] nArray = this.taskIDs;
        int n = this.taskIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int taskID = nArray[n2];
            Bukkit.getScheduler().cancelTask(taskID);
            ++n2;
        }
    }

    @Override
    public boolean check(Event e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "every " + Timespan.toString(this.period);
    }
}

