/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import ch.njol.util.StringUtils;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class EvtClick
extends SkriptEvent {
    private Literal<? extends ItemType> blocks = null;
    private Literal<? extends EntityData<?>> entities = null;
    private Literal<ItemType> tools;
    private static final int RIGHT = 1;
    private static final int LEFT = 2;
    private static final int ANY = 3;
    private int click = 3;

    static {
        Skript.registerEvent(EvtClick.class, Skript.array(PlayerInteractEvent.class, PlayerInteractEntityEvent.class), "[(left|right)[ ]][mouse[ ]]click[ing] [on %object%] [(with|using|holding) %itemtype%]", "[(left|right)[ ]][mouse[ ]]click[ing] (with|using|holding) %itemtype% on %object%");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        if (StringUtils.startsWithIgnoreCase(parser.expr, "right")) {
            this.click = 1;
        } else if (StringUtils.startsWithIgnoreCase(parser.expr, "left")) {
            this.click = 2;
        }
        if (args[matchedPattern] != null) {
            SkriptLogger.SubLog log = SkriptLogger.startSubLog();
            this.entities = args[matchedPattern].getConvertedExpression(EntityData.class);
            if (this.entities == null) {
                this.blocks = args[matchedPattern].getConvertedExpression(ItemType.class);
                log.clear();
                if (this.blocks == null) {
                    SkriptLogger.stopSubLog(log);
                    Skript.error("'" + args[matchedPattern] + "' is neither an entity type nor an item type");
                    return false;
                }
                if (!this.blocks.isSingle()) {
                    SkriptLogger.stopSubLog(log);
                    Skript.error("It's impossible to click on multiple blocks at the same time");
                    return false;
                }
            } else {
                if (!this.entities.isSingle()) {
                    SkriptLogger.stopSubLog(log);
                    Skript.error("It's impossible to click on multiple entites at the same time");
                    return false;
                }
                if (this.click == 2) {
                    SkriptLogger.stopSubLog(log);
                    Skript.error("A leftclick on an entity is an attack and thus not covered by the 'click' event, but the 'damage' event.");
                    return false;
                }
                if (this.click == 3) {
                    Skript.warning("A leftclick on an entity is an attack and thus not covered by the 'click' event, but the 'damage' event. Change this event to a rightclick to disable this warning message.");
                }
            }
            SkriptLogger.stopSubLog(log);
            log.printLog();
        }
        this.tools = args[1 - matchedPattern];
        return true;
    }

    @Override
    public boolean check(Event e) {
        Block block;
        Entity entity;
        Player player;
        if (e instanceof PlayerInteractEntityEvent) {
            if (this.click == 2 || this.entities == null && this.blocks == null) {
                return false;
            }
            player = ((PlayerInteractEntityEvent)e).getPlayer();
            entity = ((PlayerInteractEntityEvent)e).getRightClicked();
            block = null;
        } else if (e instanceof PlayerInteractEvent) {
            if (this.click == 2 && ((PlayerInteractEvent)e).getAction() != Action.LEFT_CLICK_AIR && ((PlayerInteractEvent)e).getAction() != Action.LEFT_CLICK_BLOCK) {
                return false;
            }
            if (this.click == 1 && ((PlayerInteractEvent)e).getAction() != Action.RIGHT_CLICK_AIR && ((PlayerInteractEvent)e).getAction() != Action.RIGHT_CLICK_BLOCK) {
                return false;
            }
            player = ((PlayerInteractEvent)e).getPlayer();
            block = ((PlayerInteractEvent)e).getClickedBlock();
            entity = null;
        } else {
            assert (false);
            return false;
        }
        if (this.tools != null && !this.tools.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                return t.isOfType(player.getItemInHand());
            }
        })) {
            return false;
        }
        if (this.blocks == null && this.entities == null) {
            return true;
        }
        if (this.entities != null && block == null) {
            return this.entities.check(e, new Checker<EntityData<?>>(){

                @Override
                public boolean check(EntityData<?> t) {
                    return t.isInstance(entity);
                }
            });
        }
        if (this.blocks != null && entity == null) {
            if (block != null) {
                return this.blocks.check(e, (Checker<? extends ItemType>)new Checker<ItemType>(){

                    @Override
                    public boolean check(ItemType t) {
                        return t.isOfType(block);
                    }
                });
            }
            return this.blocks.check(e, (Checker<? extends ItemType>)new Checker<ItemType>(){

                @Override
                public boolean check(ItemType t) {
                    return t.isOfType(0, (short)0);
                }
            });
        }
        return false;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.click == 2 ? "left" : (this.click == 1 ? "right" : "")) + "click" + (this.blocks == null && this.entities == null ? "" : " on " + (this.blocks == null ? this.entities.toString(e, debug) : this.blocks.toString(e, debug))) + (this.tools == null ? "" : " holding " + this.tools.toString(e, debug));
    }
}

