/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.util.Utils;
import ch.njol.util.Validate;
import org.bukkit.entity.Entity;

public class EntityType {
    public int amount = -1;
    public final EntityData<?> data;

    static {
        Skript.registerClass(new ClassInfo<EntityType>(EntityType.class, "entitytype", "entity type").defaultExpression(new SimpleLiteral<EntityType>(new EntityType(Entity.class, 1), true)).parser(new Parser<EntityType>(){

            @Override
            public EntityType parse(String s, ParseContext context) {
                return EntityType.parse(s);
            }

            @Override
            public String toString(EntityType t) {
                return t.toString();
            }

            @Override
            public String toCodeString(EntityType t) {
                return "entitytype:" + t.toString();
            }
        }));
    }

    public EntityType(EntityData<?> data, int amount) {
        Validate.notNull(data);
        this.data = data;
        this.amount = amount;
    }

    public EntityType(Class<? extends Entity> c, int amount) {
        Validate.notNull(c);
        this.data = EntityData.fromClass(c);
        this.amount = amount;
    }

    public EntityType(Entity e) {
        this.data = EntityData.fromEntity(e);
    }

    public boolean isInstance(Entity entity) {
        return this.data.isInstance(entity);
    }

    public String toString() {
        return this.getAmount() == 1 ? this.data.toString() : String.valueOf(this.amount) + " " + Utils.toPlural(this.data.toString());
    }

    public int getAmount() {
        return this.amount == -1 ? 1 : this.amount;
    }

    public boolean sameType(EntityType other) {
        if (other == null) {
            return false;
        }
        return this.data.equals(other.data);
    }

    public static EntityType parse(String s) {
        Validate.notNullOrEmpty(s, "s");
        int amount = -1;
        if (s.matches("\\d+ .+")) {
            amount = Skript.parseInt(s.split(" ", 2)[0]);
            s = s.split(" ", 2)[1];
        } else if (s.matches("(?i)an? .+")) {
            s = s.split(" ", 2)[1];
        }
        EntityData<?> data = EntityData.parseWithoutAnOrAny(s);
        if (data == null) {
            return null;
        }
        return new EntityType(data, amount);
    }
}

