/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Offset;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class EffLightning
extends Effect {
    private Expression<Offset> offsets;
    private Expression<Location> locations;
    private boolean effectOnly;

    static {
        Skript.registerEffect(EffLightning.class, "(create|strike) lightning %offsets% %locations%", "(create|strike) lightning[ ]effect %offsets% %locations%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.offsets = exprs[0];
        this.locations = exprs[1];
        this.effectOnly = matchedPattern == 1;
        return true;
    }

    @Override
    protected void execute(Event e) {
        Location[] locationArray = Offset.setOff(this.offsets.getArray(e), this.locations.getArray(e));
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location l = locationArray[n2];
            if (this.effectOnly) {
                l.getWorld().strikeLightningEffect(l);
            } else {
                l.getWorld().strikeLightning(l);
            }
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "strike lightning " + (this.effectOnly ? "effect " : "") + this.offsets.toString(e, debug) + this.locations.toString(e, debug);
    }
}

