/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Offset;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class EffExplosion
extends Effect {
    private Expression<Float> force;
    private Expression<Offset> offsets;
    private Expression<Location> locations;

    static {
        Skript.registerEffect(EffExplosion.class, "[create] explosion (of|with) (force|strength|power) %float% [%offsets% %locations%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        this.force = vars[0];
        this.offsets = vars[1];
        this.locations = vars[2];
        return true;
    }

    @Override
    public void execute(Event e) {
        float power = this.force.getSingle(e).floatValue();
        Location[] locationArray = Offset.setOff(this.offsets.getArray(e), this.locations.getArray(e));
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location l = locationArray[n2];
            l.getWorld().createExplosion(l, power);
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "create explosion of force " + this.force.toString(e, debug) + " " + this.offsets.toString(e, debug) + " " + this.locations.toString(e, debug);
    }
}

