/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timespan;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class DefaultChangers {
    public static final Changer<World, Object> timeChanger = new Changer<World, Object>(){

        @Override
        public Class<?> acceptChange(Changer.ChangeMode mode) {
            switch (mode) {
                case ADD: 
                case REMOVE: {
                    return Timespan.class;
                }
                case SET: {
                    return Time.class;
                }
            }
            return null;
        }

        public void change(World[] worlds, Object delta, Changer.ChangeMode mode) {
            int mod = 1;
            switch (mode) {
                case SET: {
                    Time time = (Time)delta;
                    World[] worldArray = worlds;
                    int n = worlds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        World w = worldArray[n2];
                        w.setTime((long)time.getTicks());
                        ++n2;
                    }
                    break;
                }
                case REMOVE: {
                    mod = -1;
                }
                case ADD: {
                    Timespan ts = (Timespan)delta;
                    World[] worldArray = worlds;
                    int n = worlds.length;
                    int n3 = 0;
                    while (n3 < n) {
                        World w = worldArray[n3];
                        w.setTime(w.getTime() + (long)(mod * ts.getTicks()));
                        ++n3;
                    }
                    break;
                }
            }
        }
    };
    public static final Changer<Entity, ItemType[]> entityChanger = new Changer<Entity, ItemType[]>(){

        @Override
        public Class<? extends ItemType[]> acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.SET) {
                return null;
            }
            return ItemType[].class;
        }

        public void change(Entity[] entities, ItemType[] delta, Changer.ChangeMode mode) {
            Entity[] entityArray = entities;
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                Entity e = entityArray[n2];
                if (!(e instanceof Player)) {
                    if (mode == Changer.ChangeMode.CLEAR) {
                        e.remove();
                    }
                } else if (mode != Changer.ChangeMode.CLEAR) {
                    PlayerInventory invi = ((Player)e).getInventory();
                    ItemType[] itemTypeArray = delta;
                    int n3 = delta.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ItemType type = itemTypeArray[n4];
                        if (mode == Changer.ChangeMode.ADD) {
                            type.addTo((Inventory)invi);
                        } else {
                            type.removeFrom((Inventory)invi);
                        }
                        ++n4;
                    }
                    ((Player)e).updateInventory();
                }
                ++n2;
            }
        }
    };
    public static final Changer<Entity, Void> nonLivingEntityChanger = new Changer<Entity, Void>(){

        @Override
        public Class<Void> acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.CLEAR) {
                return Void.class;
            }
            return null;
        }

        public void change(Entity[] entities, Void delta, Changer.ChangeMode mode) {
            Entity[] entityArray = entities;
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                Entity e = entityArray[n2];
                if (!(e instanceof Player)) {
                    e.remove();
                }
                ++n2;
            }
        }
    };
    public static final Changer<Player, ItemType[]> playerChanger = new Changer<Player, ItemType[]>(){

        @Override
        public Class<? extends ItemType[]> acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.CLEAR) {
                return null;
            }
            return ItemType[].class;
        }

        public void change(Player[] players, ItemType[] delta, Changer.ChangeMode mode) {
            Player[] playerArray = players;
            int n = players.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                PlayerInventory invi = p.getInventory();
                ItemType[] itemTypeArray = delta;
                int n3 = delta.length;
                int n4 = 0;
                while (n4 < n3) {
                    ItemType type = itemTypeArray[n4];
                    if (mode == Changer.ChangeMode.ADD) {
                        type.addTo((Inventory)invi);
                    } else {
                        type.removeFrom((Inventory)invi);
                    }
                    ++n4;
                }
                p.updateInventory();
                ++n2;
            }
        }
    };
    public static final Changer<Inventory, ItemType[]> inventoryChanger = new Changer<Inventory, ItemType[]>(){

        @Override
        public Class<ItemType[]> acceptChange(Changer.ChangeMode mode) {
            return ItemType[].class;
        }

        public void change(Inventory[] invis, ItemType[] delta, Changer.ChangeMode mode) {
            Inventory[] inventoryArray = invis;
            int n = invis.length;
            int n2 = 0;
            while (n2 < n) {
                Inventory invi = inventoryArray[n2];
                switch (mode) {
                    case SET: 
                    case CLEAR: {
                        invi.clear();
                        if (invi instanceof PlayerInventory) {
                            ((PlayerInventory)invi).setArmorContents(new ItemStack[4]);
                        }
                        if (mode == Changer.ChangeMode.CLEAR) break;
                    }
                    case ADD: {
                        ItemType type;
                        ItemType[] itemTypeArray = delta;
                        int n3 = delta.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            type = itemTypeArray[n4];
                            type.addTo(invi);
                            ++n4;
                        }
                        break;
                    }
                    case REMOVE: {
                        ItemType type;
                        ItemType[] itemTypeArray = delta;
                        int n3 = delta.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            type = itemTypeArray[n4];
                            type.removeFrom(invi);
                            ++n4;
                        }
                        break;
                    }
                }
                if (invi instanceof PlayerInventory) {
                    ((Player)invi.getHolder()).updateInventory();
                }
                ++n2;
            }
        }
    };
    public static final Changer<Block, Object> blockChanger = new Changer<Block, Object>(){

        @Override
        public Class<?> acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.SET) {
                return ItemType.class;
            }
            return ItemType[].class;
        }

        public void change(Block[] blocks, Object delta, Changer.ChangeMode mode) {
            Block[] blockArray = blocks;
            int n = blocks.length;
            int n2 = 0;
            while (n2 < n) {
                Block block = blockArray[n2];
                switch (mode) {
                    case SET: {
                        ((ItemType)delta).setBlock(block, true);
                        break;
                    }
                    case CLEAR: {
                        block.setTypeId(0, true);
                        break;
                    }
                    case ADD: 
                    case REMOVE: {
                        ItemType type;
                        int n3;
                        int n4;
                        ItemType[] itemTypeArray;
                        BlockState state = block.getState();
                        if (!(state instanceof InventoryHolder)) break;
                        if (mode == Changer.ChangeMode.ADD) {
                            itemTypeArray = (ItemType[])delta;
                            n4 = itemTypeArray.length;
                            n3 = 0;
                            while (n3 < n4) {
                                type = itemTypeArray[n3];
                                type.addTo(((InventoryHolder)state).getInventory());
                                ++n3;
                            }
                        } else {
                            itemTypeArray = (ItemType[])delta;
                            n4 = itemTypeArray.length;
                            n3 = 0;
                            while (n3 < n4) {
                                type = itemTypeArray[n3];
                                type.removeFrom(((InventoryHolder)state).getInventory());
                                ++n3;
                            }
                        }
                        state.update();
                    }
                }
                ++n2;
            }
        }
    };
}

