/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Time {
    private final int time;

    public Time(int time) {
        this.time = time % 24000;
    }

    public int getTicks() {
        return this.time;
    }

    public String toString() {
        return Time.toString(this.time);
    }

    public static String toString(int ticks) {
        int t = (ticks + 6000) % 24000;
        int hours = (int)Math.floor(t / 1000);
        int minutes = (int)Math.floor((double)(t % 1000) / 16.666666667);
        return hours + ":" + (minutes < 10 ? "0" : "") + minutes;
    }

    public static final Time parse(String s) {
        if (s.matches("\\d?\\d:\\d\\d")) {
            int hours = Skript.parseInt(s.split(":")[0]);
            if (hours >= 24) {
                Skript.error("a day only has 24 hours");
                return null;
            }
            int minutes = Skript.parseInt(s.split(":")[1]);
            if (minutes >= 60) {
                Skript.error("an hour only has 60 minutes");
                return null;
            }
            return new Time((int)Math.round((double)(hours * 1000 - 6000) + (double)minutes * 16.6666667));
        }
        Matcher m = Pattern.compile("^(?i)(\\d?\\d)(:(\\d\\d))? ?(am|pm)$").matcher(s);
        if (m.matches()) {
            int hours = Skript.parseInt(m.group(1));
            if (hours > 12) {
                Skript.error("using 12-hour format does not allow more than 12 hours");
                return null;
            }
            int minutes = 0;
            if (m.group(3) != null) {
                minutes = Skript.parseInt(m.group(3));
            }
            if (minutes >= 60) {
                Skript.error("an hour only has 60 minutes");
                return null;
            }
            if (m.group(4).equalsIgnoreCase("pm")) {
                hours += 12;
            }
            return new Time((int)Math.round((double)(hours * 1000 - 6000) + (double)minutes * 16.6666667));
        }
        return null;
    }

    public int hashCode() {
        return this.time;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Time)) {
            return false;
        }
        Time other = (Time)obj;
        return this.time == other.time;
    }
}

