/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.classes.Converter;
import ch.njol.skript.util.Java7FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

public abstract class FileUtils {
    private static final boolean RUNNINGJAVA7 = !System.getProperty("java.version").startsWith("1.6");
    private static final SimpleDateFormat backupFormat = new SimpleDateFormat("yyyy-MM-dd_kk-mm");

    private FileUtils() {
    }

    public static final File backup(File f) throws IOException {
        File backup;
        String ext;
        String name = f.getName();
        int c = name.lastIndexOf(46);
        String string = ext = c == -1 ? null : name.substring(c + 1);
        if (c != -1) {
            name = name.substring(0, c);
        }
        if ((backup = new File(f.getParentFile(), String.valueOf(name) + "_backup_" + backupFormat.format(System.currentTimeMillis()) + (ext == null ? "" : "." + ext))).exists()) {
            throw new IOException("backup file " + backup.getName() + " does already exist");
        }
        FileUtils.copy(f, backup);
        return backup;
    }

    public static final void move(File from, File to) throws IOException {
        if (RUNNINGJAVA7) {
            Java7FileUtils.move(from, to);
        } else if (!from.renameTo(to)) {
            throw new IOException("Can't rename " + from.getName() + " to " + to.getName());
        }
    }

    public static final void copy(File from, File to) throws IOException {
        if (RUNNINGJAVA7) {
            Java7FileUtils.copy(from, to);
        } else {
            if (!to.createNewFile()) {
                throw new IOException("Can't copy " + from.getName() + " to " + to.getName() + ": Can't create new file");
            }
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                int bytesRead;
                in = new FileInputStream(from);
                out = new FileOutputStream(to);
                byte[] buffer = new byte[4096];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static final Collection<File> renameAll(File directory, Converter<String, String> renamer) throws IOException {
        ArrayList<File> changed = new ArrayList<File>();
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                changed.addAll(FileUtils.renameAll(f, renamer));
            } else {
                String newName = renamer.convert(f.getName());
                if (newName != null) {
                    File newFile = new File(f.getParent(), newName);
                    FileUtils.move(f, newFile);
                    changed.add(newFile);
                }
            }
            ++n2;
        }
        return changed;
    }
}

