/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.util;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.lang.Debuggable;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.StringMode;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.event.Event;

public class VariableString
implements Debuggable {
    private final ArrayList<Object> string;
    private final boolean isSimple;
    private final String simple;
    private StringMode mode;
    public static final Map<String, Pattern> variableNames = new HashMap<String, Pattern>();

    private VariableString(String s, StringMode mode) {
        this.string = null;
        this.isSimple = true;
        this.simple = s;
        this.mode = mode;
    }

    private VariableString(ArrayList<Object> string, StringMode mode) {
        this.isSimple = false;
        this.simple = null;
        this.string = string;
        this.mode = mode;
    }

    public static VariableString newInstance(String s) {
        return VariableString.newInstance(s, StringMode.MESSAGE);
    }

    public static VariableString newInstance(String s, StringMode mode) {
        ArrayList<Object> string = new ArrayList<Object>();
        int c = s.indexOf(37);
        if (c != -1) {
            string.add(s.substring(0, c));
            while (c != s.length()) {
                int b;
                int c2 = s.indexOf(37, c + 1);
                int a = c;
                while (c2 != -1 && (b = s.indexOf(123, a + 1)) != -1 && b < c2) {
                    int b2 = VariableString.nextBracket(s, '}', '{', b + 1);
                    if (b2 == -1) {
                        Skript.error("Missing closing bracket '}' to end variable");
                        return null;
                    }
                    c2 = s.indexOf(37, b2 + 1);
                    a = b2;
                }
                if (c2 == -1) {
                    Skript.error("The percent sign is used for expressions (e.g. %player%). To insert a %, type it twice: %%.");
                    return null;
                }
                if (c + 1 == c2) {
                    string.add("%");
                } else {
                    Expression expr = (Expression)SkriptParser.parse(s.substring(c + 1, c2), Skript.getExpressions().iterator(), false, true, "can't understand the expression %" + s.substring(c + 1, c2) + "%");
                    if (expr == null) {
                        return null;
                    }
                    string.add(expr);
                }
                c = s.indexOf(37, c2 + 1);
                if (c == -1) {
                    c = s.length();
                }
                string.add(s.substring(c2 + 1, c));
            }
        } else {
            string.add(s);
        }
        if (mode == StringMode.VARIABLE_NAME && !variableNames.containsKey(s)) {
            if (s.startsWith("%") && !Skript.disableVariableConflictWarnings) {
                Skript.warning("Starting a variable's name with an expression is discouraged ({" + s + "}). You could prefix it with the script's name: {" + StringUtils.substring(ScriptLoader.currentScript.getFileName(), 0, -3) + "." + s + "}");
            }
            StringBuilder p = new StringBuilder();
            for (Object o : string) {
                if (o instanceof Expression) {
                    p.append("[^%](.*[^%])?");
                    continue;
                }
                p.append(Pattern.quote(o.toString()));
            }
            Pattern pattern = Pattern.compile(p.toString());
            for (Map.Entry<String, Pattern> e : variableNames.entrySet()) {
                if (!e.getValue().matcher(s).matches() && !pattern.matcher(e.getKey()).matches()) continue;
                Skript.warning("Possible name conflict of variables {" + s + "} and {" + e.getKey() + "} (there might be more conflicts).");
                break;
            }
            variableNames.put(s, pattern);
        }
        if (c == -1) {
            return new VariableString(s, mode);
        }
        return new VariableString(string, mode);
    }

    private static int nextBracket(String s, char closingBracket, char openingBracket, int start) {
        int n = 0;
        int i = start;
        while (i < s.length()) {
            if (s.charAt(i) == closingBracket) {
                if (n == 0) {
                    return i;
                }
                --n;
            } else if (s.charAt(i) == openingBracket) {
                ++n;
            }
            ++i;
        }
        return -1;
    }

    public static VariableString[] makeStrings(String[] args) {
        VariableString[] strings = new VariableString[args.length];
        int j = 0;
        int i = 0;
        while (i < args.length) {
            VariableString vs = VariableString.newInstance(args[i]);
            if (vs != null) {
                strings[j++] = vs;
            }
            ++i;
        }
        if (j != args.length) {
            return Arrays.copyOf(strings, j);
        }
        return strings;
    }

    public static VariableString[] makeStringsFromQuoted(List<String> args) {
        VariableString[] strings = new VariableString[args.size()];
        int i = 0;
        while (i < args.size()) {
            assert (args.get(i).startsWith("\"") && args.get(i).endsWith("\""));
            VariableString vs = VariableString.newInstance(args.get(i).substring(1, args.get(i).length() - 1));
            if (vs == null) {
                return null;
            }
            strings[i] = vs;
            ++i;
        }
        return strings;
    }

    public String toString(Event e) {
        if (this.isSimple) {
            return this.simple;
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.string.size()) {
            Object o = this.string.get(i);
            if (o instanceof Expression) {
                boolean plural = false;
                if (this.mode == StringMode.MESSAGE && i + 1 < this.string.size() && this.string.get(i + 1) instanceof String && ((String)this.string.get(i + 1)).startsWith("s ")) {
                    plural = true;
                }
                if (this.mode == StringMode.MESSAGE && (plural || Math.abs(StringUtils.numberBefore(b, b.length() - 1)) != 1)) {
                    b.append(Skript.toString(((Expression)o).getArray(e), ((Expression)o).getAnd(), this.mode, true));
                } else {
                    b.append(Skript.toString(((Expression)o).getArray(e), ((Expression)o).getAnd(), this.mode, false));
                }
            } else {
                b.append(o);
            }
            ++i;
        }
        return b.toString();
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (this.isSimple) {
            return String.valueOf('\"') + this.simple + '\"';
        }
        StringBuilder b = new StringBuilder("\"");
        for (Object o : this.string) {
            if (o instanceof Expression) {
                b.append("%" + ((Expression)o).toString(e, debug) + "%");
                continue;
            }
            b.append(o);
        }
        b.append('\"');
        return b.toString();
    }

    public String getDefaultVariableName() {
        if (this.isSimple) {
            return this.simple;
        }
        StringBuilder b = new StringBuilder();
        for (Object o : this.string) {
            if (o instanceof Expression) {
                b.append("<" + Skript.getSuperClassInfo(((Expression)o).getReturnType()).getCodeName() + ">");
                continue;
            }
            b.append(o);
        }
        return b.toString();
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public StringMode getMode() {
        return this.mode;
    }

    public void setMode(StringMode mode) {
        this.mode = mode;
    }
}

