/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.TriggerItem;
import java.util.List;
import org.bukkit.event.Event;

public abstract class TriggerSection
extends TriggerItem {
    private TriggerItem first = null;
    protected TriggerItem last = null;

    protected TriggerSection(List<TriggerItem> items) {
        this.setTriggerItems(items);
    }

    protected TriggerSection(SectionNode node) {
        ScriptLoader.currentSections.add(this);
        this.setTriggerItems(ScriptLoader.loadItems(node));
        ScriptLoader.currentSections.remove(ScriptLoader.currentSections.size() - 1);
    }

    protected TriggerSection() {
    }

    protected void setTriggerItems(List<TriggerItem> items) {
        if (!items.isEmpty()) {
            this.first = items.get(0);
            this.last = items.get(items.size() - 1);
            this.last.setNext(this.getNext());
        }
        for (TriggerItem item : items) {
            item.setParent(this);
        }
    }

    @Override
    public void setNext(TriggerItem next) {
        super.setNext(next);
        if (this.last != null) {
            this.last.setNext(next);
        }
    }

    @Override
    protected final boolean run(Event e) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected abstract TriggerItem walk(Event var1);

    protected final TriggerItem walk(Event e, boolean run) {
        this.debug(e, run);
        if (run && this.first != null) {
            return this.first;
        }
        return this.getNext();
    }
}

