/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.expressions.base.WrapperExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.UnparsedLiteral;
import org.bukkit.event.Event;

public class ExprTimeState
extends WrapperExpression<Object> {
    static {
        Skript.registerExpression(ExprTimeState.class, Object.class, Skript.ExpressionType.PROPERTY, "(former|past) [state] [of] %object%", "%object% before [the event]", "(future|to-be) [state] [of] %object%", "%object%(-to-be| after[(wards| the event)])");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        Expression<?> expr = vars[0];
        if (expr instanceof UnparsedLiteral) {
            return false;
        }
        if (isDelayed == 1) {
            Skript.error("Cannot use time states after the event has already passed");
            return false;
        }
        if (!expr.setTime(matchedPattern >= 2 ? 1 : -1)) {
            Skript.error(expr + " does not have a " + (matchedPattern >= 2 ? "future" : "past") + " state");
            return false;
        }
        this.setExpr(expr);
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the " + (this.getTime() == -1 ? "past" : "future") + " state of " + this.getExpr().toString(e, debug);
    }
}

