/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.util.Math2;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class ExprFoodLevel
extends PropertyExpression<Player, Float> {
    private Expression<Player> players;

    static {
        Skript.registerExpression(ExprFoodLevel.class, Float.class, Skript.ExpressionType.PROPERTY, "[the] (food|hunger)[[ ](level|meter|bar)] [of %player%]", "%player%'[s] (food|hunger)[[ ](level|meter|bar)]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        this.players = vars[0];
        this.setExpr(this.players);
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the food level of " + this.players.toString(e, debug);
    }

    protected Float[] get(Event e, Player[] source) {
        if (this.getTime() >= 0 && this.players.isDefault() && e instanceof FoodLevelChangeEvent && !Delay.isDelayed(e)) {
            return new Float[]{Float.valueOf(0.5f * (float)((FoodLevelChangeEvent)e).getFoodLevel())};
        }
        return this.get(source, new Getter<Float, Player>(){

            @Override
            public Float get(Player p) {
                return Float.valueOf(0.5f * (float)p.getFoodLevel());
            }
        });
    }

    @Override
    public Class<?> acceptChange(Changer.ChangeMode mode) {
        return Float.class;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        int s = 0;
        if (mode != Changer.ChangeMode.CLEAR) {
            s = Math.round(((Float)delta).floatValue() * 2.0f);
        }
        switch (mode) {
            case SET: 
            case CLEAR: {
                if (this.getTime() >= 0 && this.players.isDefault() && e instanceof FoodLevelChangeEvent && !Delay.isDelayed(e)) {
                    ((FoodLevelChangeEvent)e).setFoodLevel(Math2.fit(0, s, 20));
                    return;
                }
                Player[] playerArray = this.players.getArray(e);
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player player = playerArray[n2];
                    player.setFoodLevel(Math2.fit(0, s, 20));
                    ++n2;
                }
                return;
            }
            case ADD: {
                if (this.getTime() >= 0 && this.players.isDefault() && e instanceof FoodLevelChangeEvent && !Delay.isDelayed(e)) {
                    ((FoodLevelChangeEvent)e).setFoodLevel(Math2.fit(0, ((FoodLevelChangeEvent)e).getFoodLevel() + s, 20));
                    return;
                }
                Player[] playerArray = this.players.getArray(e);
                int n = playerArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Player player = playerArray[n3];
                    player.setFoodLevel(Math2.fit(0, player.getFoodLevel() + s, 20));
                    ++n3;
                }
                return;
            }
            case REMOVE: {
                if (this.getTime() >= 0 && this.players.isDefault() && e instanceof FoodLevelChangeEvent && !Delay.isDelayed(e)) {
                    ((FoodLevelChangeEvent)e).setFoodLevel(Math2.fit(0, ((FoodLevelChangeEvent)e).getFoodLevel() - s, 20));
                    return;
                }
                Player[] playerArray = this.players.getArray(e);
                int n = playerArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Player player = playerArray[n4];
                    player.setFoodLevel(Math2.fit(0, player.getFoodLevel() - s, 20));
                    ++n4;
                }
                return;
            }
        }
    }

    @Override
    public Class<Float> getReturnType() {
        return Float.class;
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, FoodLevelChangeEvent.class, this.players);
    }
}

