/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Arithmetic;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.conditions.CondIs;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.SimpleExpression;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

public class ExprDifference
extends SimpleExpression<Object> {
    private Expression<?> first;
    private Expression<?> second;
    private Arithmetic<?, ?> math;
    private Class<?> relativeType;
    private Object[] one;

    static {
        Skript.registerExpression(ExprDifference.class, Object.class, Skript.ExpressionType.COMBINED, "difference (between|of) %object% and %object%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        ClassInfo<Double> ci;
        this.first = exprs[0];
        this.second = exprs[1];
        if (this.first instanceof Variable && this.second instanceof Variable) {
            ci = Skript.getExactClassInfo(Double.class);
            this.first = this.first.getConvertedExpression(Double.class);
            this.second = this.second.getConvertedExpression(Double.class);
        } else if (this.first instanceof UnparsedLiteral && this.second instanceof UnparsedLiteral) {
            this.first = this.first.getConvertedExpression(Object.class);
            this.second = this.second.getConvertedExpression(Object.class);
            if (this.first == null || this.second == null) {
                return false;
            }
            ci = Skript.getSuperClassInfo(this.second.getReturnType().isAssignableFrom(this.first.getReturnType()) ? this.second.getReturnType() : this.first.getReturnType());
        } else {
            if (this.first instanceof UnparsedLiteral) {
                this.first = this.first.getConvertedExpression(this.second.getReturnType());
                if (this.first == null) {
                    return false;
                }
            } else if (this.second instanceof UnparsedLiteral) {
                this.second = this.second.getConvertedExpression(this.first.getReturnType());
                if (this.second == null) {
                    return false;
                }
            }
            if (this.first instanceof Variable) {
                this.first = this.first.getConvertedExpression(this.second.getReturnType());
            } else if (this.second instanceof Variable) {
                this.second = this.second.getConvertedExpression(this.first.getReturnType());
            }
            ci = Skript.getSuperClassInfo(this.second.getReturnType().isAssignableFrom(this.first.getReturnType()) ? this.second.getReturnType() : this.first.getReturnType());
        }
        if (ci.getMath() == null) {
            Skript.error("Can't get the difference of " + CondIs.f(this.first) + " and " + CondIs.f(this.second));
            return false;
        }
        this.math = ci.getMath();
        this.relativeType = ci.getMathRelativeType();
        this.one = (Object[])Array.newInstance(this.relativeType, 1);
        return true;
    }

    @Override
    protected Object[] get(Event e) {
        Object f = this.first.getSingle(e);
        Object s = this.second.getSingle(e);
        if (s == null || f == null) {
            return null;
        }
        this.one[0] = ExprDifference.diff(this.math, f, s);
        return this.one;
    }

    private static <A> Object diff(Arithmetic<A, ?> math, Object f, Object s) {
        return math.difference(f, s);
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.relativeType;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "difference between " + this.first.toString(e, debug) + " and " + this.second.toString(e, debug);
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean getAnd() {
        return false;
    }
}

