/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Aliases;
import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Utils;
import java.lang.reflect.Array;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class ExprClicked
extends SimpleExpression<Object> {
    private EntityData<?> entityType = null;
    private ItemType itemType = null;
    private Object[] one;

    static {
        Skript.registerExpression(ExprClicked.class, Object.class, Skript.ExpressionType.SIMPLE, "[the] clicked <.+>");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        String s = parseResult.regexes.get(0).group();
        SkriptLogger.SubLog log = SkriptLogger.startSubLog();
        this.entityType = EntityData.parse(s);
        if (this.entityType == null) {
            log.clear();
            if (!(s.equalsIgnoreCase("block") || s.equalsIgnoreCase("any block") || s.equalsIgnoreCase("a block"))) {
                this.itemType = Aliases.parseItemType(s);
                log.stop();
                if (this.itemType == null) {
                    Skript.error("'" + s + "' is neither an entity type nor an item type");
                    return false;
                }
            }
            log.stop();
            log.printLog();
            if (!Utils.contains(ScriptLoader.currentEvents, PlayerInteractEvent.class)) {
                Skript.error("The expression 'clicked block' can only be used in a click event");
                return false;
            }
            this.one = new Block[1];
        } else {
            log.stop();
            log.printLog();
            if (!Utils.containsAny(ScriptLoader.currentEvents, PlayerInteractEntityEvent.class, EntityDamageByEntityEvent.class)) {
                Skript.error("The expression '" + parseResult.expr + "' can only be used in a click event");
                return false;
            }
            this.one = (Entity[])Array.newInstance(this.entityType.getType(), 1);
        }
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.entityType != null ? this.entityType.getType() : Block.class;
    }

    @Override
    protected Object[] get(Event e) {
        Entity en;
        if (e instanceof PlayerInteractEvent) {
            if (this.entityType != null) {
                return null;
            }
            this.one[0] = ((PlayerInteractEvent)e).getClickedBlock();
            if (this.itemType == null || this.itemType.isOfType((Block)this.one[0])) {
                return this.one;
            }
            return null;
        }
        if (this.entityType == null) {
            return null;
        }
        if (e instanceof PlayerInteractEntityEvent) {
            en = Utils.validate(((PlayerInteractEntityEvent)e).getRightClicked());
        } else {
            if (!(((EntityDamageByEntityEvent)e).getDamager() instanceof Player)) {
                return null;
            }
            en = Utils.validate(((EntityDamageByEntityEvent)e).getEntity());
        }
        if (this.entityType.isInstance(en)) {
            this.one[0] = en;
            return this.one;
        }
        return null;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "clicked " + (this.entityType != null ? this.entityType : (this.itemType != null ? this.itemType : "block"));
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

