/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Aliases;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Arithmetic;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.EnumSerializer;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.ItemData;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Offset;
import ch.njol.skript.util.Slot;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timeperiod;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.WeatherType;
import org.bukkit.inventory.ItemStack;

public class SkriptClasses {
    static {
        Skript.registerClass(new ClassInfo<WeatherType>(WeatherType.class, "weathertype", "weather type").user("weather ?types?", "weather conditions?", "weathers?").defaultExpression(new SimpleLiteral<WeatherType>(WeatherType.CLEAR, true)).parser(new Parser<WeatherType>(){

            @Override
            public WeatherType parse(String s, ParseContext context) {
                return WeatherType.parse(s);
            }

            @Override
            public String toString(WeatherType o) {
                return o.toString();
            }

            @Override
            public String toCodeString(WeatherType o) {
                return o.name().toLowerCase();
            }
        }).serializer(new EnumSerializer<WeatherType>(WeatherType.class)));
        Skript.registerClass(new ClassInfo<ItemType>(ItemType.class, "itemtype", "item type").user("item ?types?", "items", "materials").parser(new Parser<ItemType>(){

            @Override
            public ItemType parse(String s, ParseContext context) {
                return Aliases.parseItemType(s);
            }

            @Override
            public String toString(ItemType t) {
                return t.toString();
            }

            @Override
            public String getDebugMessage(ItemType t) {
                return t.getDebugMessage();
            }

            @Override
            public String toCodeString(ItemType t) {
                StringBuilder b = new StringBuilder("itemtype:");
                b.append(t.getInternalAmount());
                b.append("," + t.isAll());
                for (ItemData d : t.getTypes()) {
                    b.append("," + d.getId());
                    b.append(":" + d.dataMin);
                    b.append("/" + d.dataMax);
                }
                return b.toString();
            }
        }).serializer(new Serializer<ItemType>(){

            @Override
            public String serialize(ItemType t) {
                StringBuilder b = new StringBuilder();
                b.append(t.getInternalAmount());
                b.append("," + t.isAll());
                for (ItemData d : t.getTypes()) {
                    b.append("," + d.getId());
                    b.append(":" + d.dataMin);
                    b.append("/" + d.dataMax);
                }
                return b.toString();
            }

            @Override
            public ItemType deserialize(String s) {
                ItemType t;
                String[] split;
                block7: {
                    split = s.split("[,:/]");
                    if (split.length < 5 || (split.length - 2) % 3 != 0) {
                        return null;
                    }
                    t = new ItemType();
                    t.setAmount(Integer.parseInt(split[0]));
                    if (split[1].equals("true")) {
                        t.setAll(true);
                        break block7;
                    }
                    if (split[1].equals("false")) {
                        t.setAll(false);
                        break block7;
                    }
                    return null;
                }
                try {
                    int i = 2;
                    while (i < split.length) {
                        t.add(new ItemData(Integer.parseInt(split[i]), Short.parseShort(split[i + 1]), Short.parseShort(split[i + 2])));
                        i += 3;
                    }
                    return t;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<Time>(Time.class, "time", "time").user("times?").defaultExpression(new EventValueExpression<Time>(Time.class)).parser(new Parser<Time>(){

            @Override
            public Time parse(String s, ParseContext context) {
                return Time.parse(s);
            }

            @Override
            public String toString(Time t) {
                return t.toString();
            }

            @Override
            public String toCodeString(Time o) {
                return "time:" + o.getTicks();
            }
        }).serializer(new Serializer<Time>(){

            @Override
            public String serialize(Time t) {
                return "" + t.getTicks();
            }

            @Override
            public Time deserialize(String s) {
                try {
                    return new Time(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        new Timespan(0);
        Skript.registerClass(new ClassInfo<Timeperiod>(Timeperiod.class, "timeperiod", "time period").user("time ?periods?", "durations?").defaultExpression(new SimpleLiteral<Timeperiod>(new Timeperiod(0, 23999), true)).parser(new Parser<Timeperiod>(){

            @Override
            public Timeperiod parse(String s, ParseContext context) {
                if (s.equalsIgnoreCase("day")) {
                    return new Timeperiod(0, 11999);
                }
                if (s.equalsIgnoreCase("dusk")) {
                    return new Timeperiod(12000, 13799);
                }
                if (s.equalsIgnoreCase("night")) {
                    return new Timeperiod(13800, 22199);
                }
                if (s.equalsIgnoreCase("dawn")) {
                    return new Timeperiod(22200, 23999);
                }
                int c = s.indexOf(45);
                if (c == -1) {
                    Time t = Time.parse(s);
                    if (t == null) {
                        return null;
                    }
                    return new Timeperiod(t.getTicks());
                }
                Time t1 = Time.parse(s.substring(0, c).trim());
                Time t2 = Time.parse(s.substring(c + 1).trim());
                if (t1 == null || t2 == null) {
                    return null;
                }
                return new Timeperiod(t1.getTicks(), t2.getTicks());
            }

            @Override
            public String toString(Timeperiod o) {
                return o.toString();
            }

            @Override
            public String toCodeString(Timeperiod o) {
                return "timeperiod:" + o.start + "-" + o.end;
            }
        }).serializer(new Serializer<Timeperiod>(){

            @Override
            public String serialize(Timeperiod t) {
                return String.valueOf(t.start) + "-" + t.end;
            }

            @Override
            public Timeperiod deserialize(String s) {
                String[] split = s.split("-");
                if (split.length != 2) {
                    return null;
                }
                try {
                    return new Timeperiod(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
        Skript.registerClass(new ClassInfo<Date>(Date.class, "date", "date").serializer(new Serializer<Date>(){

            @Override
            public String serialize(Date d) {
                return "" + d.timestamp;
            }

            @Override
            public Date deserialize(String s) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }).math(Timespan.class, new Arithmetic<Date, Timespan>(){

            @Override
            public Timespan difference(Date first, Date second) {
                return first.difference(second);
            }
        }));
        Skript.registerClass(new ClassInfo<Offset>(Offset.class, "offset", "offset").user("offset").defaultExpression(new SimpleLiteral<Offset>(new Offset(0.0, 0.0, 0.0), true)).parser(new Parser<Offset>(){

            @Override
            public Offset parse(String s, ParseContext context) {
                return Offset.parse(s);
            }

            @Override
            public String toString(Offset o) {
                return o.toString();
            }

            @Override
            public String toCodeString(Offset o) {
                return "offset:" + o.toVector().toString();
            }
        }));
        Skript.registerClass(new ClassInfo<Slot>(Slot.class, "slot", "slot").defaultExpression(new EventValueExpression<Slot>(Slot.class)).changer(new Changer<Slot, ItemType>(){

            @Override
            public Class<ItemType> acceptChange(Changer.ChangeMode mode) {
                return ItemType.class;
            }

            public void change(Slot[] slots, ItemType delta, Changer.ChangeMode mode) {
                ItemType type = delta;
                if (type == null && mode != Changer.ChangeMode.CLEAR) {
                    return;
                }
                Slot[] slotArray = slots;
                int n = slots.length;
                int n2 = 0;
                while (n2 < n) {
                    Slot slot = slotArray[n2];
                    switch (mode) {
                        case SET: {
                            slot.setItem(type.getItem().getRandom());
                            break;
                        }
                        case ADD: {
                            slot.setItem(type.getItem().addTo(slot.getItem()));
                            break;
                        }
                        case REMOVE: {
                            slot.setItem(type.removeFrom(slot.getItem()));
                            break;
                        }
                        case CLEAR: {
                            slot.setItem(null);
                        }
                    }
                    ++n2;
                }
            }
        }).serializeAs(ItemStack.class));
        Skript.registerClass(new ClassInfo<Color>(Color.class, "color", "color").user("colou?rs?").parser(new Parser<Color>(){

            @Override
            public String toString(Color c) {
                return c.toString();
            }

            @Override
            public Color parse(String s, ParseContext context) {
                return Color.byName(s);
            }

            @Override
            public String toCodeString(Color o) {
                return o.name().toLowerCase().replace('_', ' ');
            }
        }).serializer(new EnumSerializer<Color>(Color.class)));
    }
}

