/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.classes.Arithmetic;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.classes.Validator;
import ch.njol.skript.lang.DefaultExpression;
import java.util.regex.Pattern;

public class ClassInfo<T> {
    private final Class<T> c;
    private final String codeName;
    private final String name;
    private DefaultExpression<T> defaultExpression = null;
    private Parser<T> parser = null;
    private Pattern[] userInputPatterns = null;
    private Changer<? super T, ?> changer = null;
    private Serializer<T> serializer = null;
    private Class<?> serializeAs = null;
    private Arithmetic<T, ?> math = null;
    private Class<?> mathRelativeType = null;
    private Validator<? super T> validator = null;

    public ClassInfo(Class<T> c, String codeName, String name) {
        this.c = c;
        this.codeName = codeName;
        this.name = name;
    }

    public ClassInfo<T> parser(Parser<T> parser) {
        this.parser = parser;
        return this;
    }

    public ClassInfo<T> user(String ... userInputPatterns) {
        this.userInputPatterns = new Pattern[userInputPatterns.length];
        int i = 0;
        while (i < userInputPatterns.length) {
            this.userInputPatterns[i] = Pattern.compile("^" + userInputPatterns[i] + "$");
            ++i;
        }
        return this;
    }

    public ClassInfo<T> defaultExpression(DefaultExpression<T> defaultExpression) {
        if (!defaultExpression.isDefault()) {
            throw new IllegalArgumentException("defaultExpression.isDefault() must return true for the default expression of a class");
        }
        this.defaultExpression = defaultExpression;
        return this;
    }

    public ClassInfo<T> serializer(Serializer<T> serializer) {
        if (this.serializeAs != null) {
            throw new IllegalStateException("Can't set a serializer if this class is set to be serialized as another one");
        }
        this.serializer = serializer;
        return this;
    }

    public ClassInfo<T> serializeAs(Class<?> serializeAs) {
        if (this.serializer != null) {
            throw new IllegalStateException("Can't set this class to be serialized as another one if a serializer is already set");
        }
        this.serializeAs = serializeAs;
        return this;
    }

    public ClassInfo<T> changer(Changer<? super T, ?> changer) {
        this.changer = changer;
        return this;
    }

    public <R> ClassInfo<T> math(Class<R> relativeType, Arithmetic<T, R> math) {
        this.math = math;
        this.mathRelativeType = relativeType;
        return this;
    }

    public ClassInfo<T> validator(Validator<? super T> validator) {
        this.validator = validator;
        return this;
    }

    public Class<T> getC() {
        return this.c;
    }

    public String getName() {
        return this.name;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public DefaultExpression<T> getDefaultExpression() {
        return this.defaultExpression;
    }

    public Parser<T> getParser() {
        return this.parser;
    }

    public Pattern[] getUserInputPatterns() {
        return this.userInputPatterns;
    }

    public Changer<? super T, ?> getChanger() {
        return this.changer;
    }

    public Serializer<T> getSerializer() {
        return this.serializer;
    }

    public Class<?> getSerializeAs() {
        return this.serializeAs;
    }

    public Arithmetic<T, ?> getMath() {
        return this.math;
    }

    public Class<?> getMathRelativeType() {
        return this.mathRelativeType;
    }

    public Validator<? super T> getValidator() {
        return this.validator;
    }
}

