/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import java.util.Arrays;

public class Version
implements Comparable<Version> {
    private final int[] version = new int[3];

    public Version(int[] version) {
        if (version.length < 1 || version.length > 3) {
            throw new IllegalArgumentException("Versions must hava a minimum of 2 and a maximum of 3 numbers (given: " + version.length + ")");
        }
        int i = 0;
        while (i < version.length) {
            this.version[i] = version[i];
            ++i;
        }
    }

    public Version(String version) {
        if (!version.matches("\\d+(.\\d+){0,2}")) {
            throw new IllegalArgumentException("'" + version + "' is not a valid version string");
        }
        String[] split = version.split("\\.");
        int i = 0;
        while (i < split.length) {
            this.version[i] = Integer.parseInt(split[i]);
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)obj) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.version);
    }

    @Override
    public int compareTo(Version other) {
        int i = 0;
        while (i < 3) {
            if (this.version[i] > other.version[i]) {
                return 1;
            }
            if (this.version[i] < other.version[i]) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public boolean isSmallerThan(Version other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLargerThan(Version other) {
        return this.compareTo(other) > 0;
    }

    public String toString() {
        return String.valueOf(this.version[0]) + "." + this.version[1] + (this.version[2] == 0 ? "" : "." + this.version[2]);
    }

    public static final int compare(String v1, String v2) {
        return new Version(v1).compareTo(new Version(v2));
    }
}

