/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Arithmetic;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.util.Utils;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.util.HashMap;

public class Timespan {
    private final int ticks;
    static final Pair<String, Integer>[] simpleValues;

    static {
        final HashMap<String, Integer> simpleValues = new HashMap<String, Integer>();
        simpleValues.put("tick", 1);
        simpleValues.put("second", 20);
        simpleValues.put("minute", 1200);
        simpleValues.put("hour", 72000);
        simpleValues.put("day", 1728000);
        Skript.registerClass(new ClassInfo<Timespan>(Timespan.class, "timespan", "time span").user("time ?spans?").parser(new Parser<Timespan>(){

            @Override
            public Timespan parse(String s, ParseContext context) {
                if (s.isEmpty()) {
                    return null;
                }
                int t = 0;
                boolean minecraftTime = false;
                boolean isMinecraftTimeSet = false;
                if (s.matches("^\\d+:\\d\\d$")) {
                    String[] ss = s.split(":");
                    int[] times = new int[]{1200, 20};
                    int i = 0;
                    while (i < ss.length) {
                        t += times[i] * Skript.parseInt(ss[i]);
                        ++i;
                    }
                } else {
                    String[] subs = s.toLowerCase().split("\\s+");
                    int i = 0;
                    while (i < subs.length) {
                        String sub = subs[i];
                        if (sub.equals("and")) {
                            if (i == 0 || i == subs.length - 1) {
                                return null;
                            }
                        } else {
                            float amount = 1.0f;
                            if (sub.equalsIgnoreCase("a") || sub.equalsIgnoreCase("an")) {
                                if (i == subs.length - 1) {
                                    return null;
                                }
                                amount = 1.0f;
                                sub = subs[++i];
                            } else if (sub.matches("^\\d+(.\\d+)?$")) {
                                if (i == subs.length - 1) {
                                    return null;
                                }
                                amount = Float.parseFloat(sub);
                                sub = subs[++i];
                            }
                            if (sub.equals("real") || sub.equals("rl") || sub.equals("irl")) {
                                if (i == subs.length - 1 || isMinecraftTimeSet && minecraftTime) {
                                    return null;
                                }
                                sub = subs[++i];
                            } else if (sub.equals("mc") || sub.equals("minecraft")) {
                                if (i == subs.length - 1 || isMinecraftTimeSet && !minecraftTime) {
                                    return null;
                                }
                                minecraftTime = true;
                                sub = subs[++i];
                            }
                            if (minecraftTime) {
                                amount /= 72.0f;
                            }
                            if (sub.endsWith(",")) {
                                sub = sub.substring(0, sub.length() - 1);
                            }
                            Pair<String, Boolean> p = Utils.getPlural(sub);
                            sub = (String)p.first;
                            if (!simpleValues.containsKey(sub)) {
                                return null;
                            }
                            if (sub.equals("tick") && minecraftTime) {
                                amount *= 72.0f;
                            }
                            t += Math.round(amount * (float)((Integer)simpleValues.get(sub)).intValue());
                            isMinecraftTimeSet = true;
                        }
                        ++i;
                    }
                }
                return new Timespan(t);
            }

            @Override
            public String toString(Timespan t) {
                return t.toString();
            }

            @Override
            public String toCodeString(Timespan o) {
                return "timespan:" + o.ticks;
            }
        }).serializer(new Serializer<Timespan>(){

            @Override
            public String serialize(Timespan t) {
                return "" + t.ticks;
            }

            @Override
            public Timespan deserialize(String s) {
                try {
                    return new Timespan(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }).math(Timespan.class, new Arithmetic<Timespan, Timespan>(){

            @Override
            public Timespan difference(Timespan t1, Timespan t2) {
                return new Timespan(Math.abs(t1.getTicks() - t2.getTicks()));
            }
        }));
        Timespan.simpleValues = new Pair[]{new Pair<String, Integer>("day", 1728000), new Pair<String, Integer>("hour", 72000), new Pair<String, Integer>("minute", 1200), new Pair<String, Integer>("second", 20)};
    }

    public Timespan(int ticks) {
        if (ticks < 0) {
            throw new IllegalArgumentException("ticks must be >= 0");
        }
        this.ticks = ticks;
    }

    public int getTicks() {
        return this.ticks;
    }

    public String toString() {
        return Timespan.toString(this.ticks);
    }

    public static String toString(int ticks) {
        int i = 0;
        while (i < simpleValues.length - 1) {
            if (ticks >= (Integer)Timespan.simpleValues[i].second) {
                if (ticks % (Integer)Timespan.simpleValues[i].second != 0) {
                    return String.valueOf(Timespan.toString(Math.floor(1.0 * (double)ticks / (double)((Integer)Timespan.simpleValues[i].second).intValue()), simpleValues[i])) + " and " + Timespan.toString(1.0 * (double)(ticks % (Integer)Timespan.simpleValues[i].second) / (double)((Integer)Timespan.simpleValues[i + 1].second).intValue(), simpleValues[i + 1]);
                }
                return Timespan.toString(1.0 * (double)ticks / (double)((Integer)Timespan.simpleValues[i].second).intValue(), simpleValues[i]);
            }
            ++i;
        }
        return Timespan.toString(1.0 * (double)ticks / (double)((Integer)Timespan.simpleValues[Timespan.simpleValues.length - 1].second).intValue(), simpleValues[simpleValues.length - 1]);
    }

    private static String toString(double amount, Pair<String, Integer> p) {
        return String.valueOf(StringUtils.toString(amount, 2)) + " " + Utils.toPlural((String)p.first, amount != 1.0);
    }
}

