/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.util.Utils;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public abstract class BlockUtils {
    private static final BlockFace[] torch;
    private static final BlockFace[] button;
    private static final BlockFace[] ladder;
    private static final BlockFace[] wallSign;
    private static final BlockFace[] trapdoor;
    private static final BlockFace[] lever;
    private static final BlockFace[] cocoa;
    private static final BlockFace[] tripwireHook;
    private static final BlockFace[][] attached;
    private static final BlockFace[] bed;
    private static final int[] solid;
    private static final boolean[] isSolid;

    static {
        BlockFace[] blockFaceArray = new BlockFace[6];
        blockFaceArray[1] = BlockFace.WEST;
        blockFaceArray[2] = BlockFace.EAST;
        blockFaceArray[3] = BlockFace.NORTH;
        blockFaceArray[4] = BlockFace.SOUTH;
        blockFaceArray[5] = BlockFace.DOWN;
        torch = blockFaceArray;
        BlockFace[] blockFaceArray2 = new BlockFace[13];
        blockFaceArray2[1] = BlockFace.WEST;
        blockFaceArray2[2] = BlockFace.EAST;
        blockFaceArray2[3] = BlockFace.NORTH;
        blockFaceArray2[4] = BlockFace.SOUTH;
        blockFaceArray2[9] = BlockFace.WEST;
        blockFaceArray2[10] = BlockFace.EAST;
        blockFaceArray2[11] = BlockFace.NORTH;
        blockFaceArray2[12] = BlockFace.SOUTH;
        button = blockFaceArray2;
        BlockFace[] blockFaceArray3 = new BlockFace[6];
        blockFaceArray3[2] = BlockFace.SOUTH;
        blockFaceArray3[3] = BlockFace.NORTH;
        blockFaceArray3[4] = BlockFace.EAST;
        blockFaceArray3[5] = BlockFace.WEST;
        ladder = blockFaceArray3;
        wallSign = ladder;
        trapdoor = new BlockFace[]{BlockFace.SOUTH, BlockFace.NORTH, BlockFace.EAST, BlockFace.WEST};
        lever = new BlockFace[]{BlockFace.UP, BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.DOWN, BlockFace.DOWN, BlockFace.UP, BlockFace.UP, BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.DOWN, BlockFace.DOWN, BlockFace.UP};
        cocoa = new BlockFace[]{BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST};
        tripwireHook = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
        attached = new BlockFace[256][];
        BlockUtils.attached[Material.TORCH.getId()] = torch;
        BlockUtils.attached[Material.STONE_BUTTON.getId()] = button;
        BlockUtils.attached[Material.LADDER.getId()] = ladder;
        BlockUtils.attached[Material.WALL_SIGN.getId()] = wallSign;
        BlockUtils.attached[Material.TRAP_DOOR.getId()] = trapdoor;
        BlockUtils.attached[Material.LEVER.getId()] = lever;
        BlockUtils.attached[Material.COCOA.getId()] = cocoa;
        BlockUtils.attached[Material.TRIPWIRE_HOOK.getId()] = tripwireHook;
        bed = new BlockFace[]{BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST};
        solid = new int[]{1, 2, 3, 4, 5, 7, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 29, 33, 35, 41, 42, 43, 45, 46, 47, 48, 49, 52, 54, 56, 57, 58, 60, 61, 62, 73, 74, 79, 80, 82, 84, 86, 87, 88, 89, 91, 95, 97, 98, 99, 100, 103, 110, 112, 120, 121, 123, 124, 125, 129, 130, 133};
        isSolid = new boolean[256];
        int[] nArray = solid;
        int n = solid.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            BlockUtils.isSolid[i] = true;
            ++n2;
        }
    }

    public static boolean set(Block b, int type, byte dataMin, byte dataMax, boolean applyPhysics) {
        boolean any;
        boolean bl = any = dataMin == -1 && dataMax == -1;
        if (dataMin == -1) {
            dataMin = 0;
        }
        if (dataMax == -1) {
            dataMax = (byte)15;
        }
        if (type < 0 || type > 255) {
            throw new IllegalArgumentException("Invalid block type id " + type);
        }
        if (dataMin < 0 || dataMin > dataMax || dataMax > 15) {
            throw new IllegalArgumentException("Invalid data range " + dataMin + " to " + dataMax);
        }
        BlockFace[] attach = attached[type];
        if (attach != null) {
            if (dataMin >= attach.length) {
                return false;
            }
            byte down = (byte)Utils.indexOf(attach, BlockFace.DOWN, (int)dataMin, (int)(dataMax = (byte)Math.min(dataMax, attach.length - 1)));
            if (down != -1 && BlockUtils.isSolid(b.getRelative(BlockFace.DOWN).getTypeId())) {
                b.setTypeIdAndData(type, down, applyPhysics);
                return true;
            }
            int[] nArray = Utils.permutation(dataMin, dataMax + 1);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int data = nArray[n2];
                BlockFace f = attach[data];
                if (f != null && BlockUtils.isSolid(b.getRelative(f).getTypeId())) {
                    b.setTypeIdAndData(type, (byte)data, applyPhysics);
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (type == Material.IRON_DOOR_BLOCK.getId() || type == Material.WOODEN_DOOR.getId()) {
            int up = b.getRelative(BlockFace.UP).getTypeId();
            int down = b.getRelative(BlockFace.DOWN).getTypeId();
            if (up == 0 || up == type && b.getRelative(BlockFace.UP).getData() >= 8) {
                if (dataMin >= 8) {
                    return false;
                }
                if (!BlockUtils.isSolid(down)) {
                    return false;
                }
                dataMax = (byte)Math.min(dataMax, 8);
                byte data = (byte)Utils.random(dataMin, dataMax + 1);
                if (up != type) {
                    b.getRelative(BlockFace.UP).setTypeIdAndData(type, (byte)8, false);
                }
                b.setTypeIdAndData(type, data, applyPhysics);
                return true;
            }
            if (down == 0 || down == type && b.getRelative(BlockFace.DOWN).getData() < 8) {
                if (dataMax < 8) {
                    return false;
                }
                if (!BlockUtils.isSolid(b.getRelative(BlockFace.DOWN, 2).getTypeId())) {
                    return false;
                }
                dataMin = (byte)Math.max(dataMin, 8);
                byte data = (byte)Utils.random(dataMin, dataMax + 1);
                if (down != type) {
                    b.getRelative(BlockFace.DOWN).setTypeIdAndData(type, (byte)0, false);
                }
                b.setTypeIdAndData(type, data, applyPhysics);
                return true;
            }
            return false;
        }
        if (type == Material.BED_BLOCK.getId()) {
            int[] nArray = Utils.permutation(dataMin, dataMax + 1);
            int n = nArray.length;
            int n3 = 0;
            while (n3 < n) {
                int data = nArray[n3];
                boolean head = (data & 8) == 8;
                BlockFace f = bed[data & 3];
                if (head) {
                    if (b.getRelative(f, -1).getTypeId() == 0) {
                        b.getRelative(f, -1).setTypeIdAndData(type, (byte)(data & 0xFFFFFFF7), false);
                        b.setTypeIdAndData(type, (byte)data, applyPhysics);
                        return true;
                    }
                } else if (b.getRelative(f).getTypeId() == 0) {
                    b.getRelative(f).setTypeIdAndData(type, (byte)(data | 8), false);
                    b.setTypeIdAndData(type, (byte)data, applyPhysics);
                    return true;
                }
                ++n3;
            }
            return false;
        }
        b.setTypeIdAndData(type, any ? (byte)0 : (byte)Utils.random(dataMin, dataMax + 1), applyPhysics);
        return true;
    }

    public static final boolean isSolid(int type) {
        if (type < 0 || type > 255) {
            throw new IllegalArgumentException(String.valueOf(type) + " is not a block id");
        }
        return isSolid[type];
    }

    public static Iterable<Block> getBlocksAround(Block b) {
        return Arrays.asList(b.getRelative(BlockFace.NORTH), b.getRelative(BlockFace.EAST), b.getRelative(BlockFace.SOUTH), b.getRelative(BlockFace.WEST));
    }

    public static Iterable<BlockFace> getFaces() {
        return Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    }
}

