/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.util.ContanerExpression;
import ch.njol.skript.util.Container;
import ch.njol.util.Validate;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.event.Event;

public class Loop
extends TriggerSection {
    private final Expression<?> expr;
    private final Map<Event, Object> current = new WeakHashMap<Event, Object>();
    private final Map<Event, Iterator<?>> currentIter = new WeakHashMap();
    private TriggerItem actualNext;

    public <T> Loop(Expression<?> expr, SectionNode node) {
        Validate.notNull(expr, node);
        if (Container.class.isAssignableFrom(expr.getReturnType())) {
            Container.ContainerType type = expr.getReturnType().getAnnotation(Container.ContainerType.class);
            if (type == null) {
                throw new SkriptAPIException(String.valueOf(expr.getReturnType().getName()) + " implements Container but is missing the required @ContainerType annotation");
            }
            this.expr = new ContanerExpression(expr, type.value());
        } else {
            this.expr = expr;
        }
        ScriptLoader.currentLoops.add(this);
        this.setTriggerItems(ScriptLoader.loadItems(node));
        ScriptLoader.currentLoops.remove(ScriptLoader.currentLoops.size() - 1);
        super.setNext(this);
    }

    @Override
    protected TriggerItem walk(Event e) {
        Iterator<?> iter = this.currentIter.get(e);
        if (iter == null && (iter = this.expr.iterator(e)) != null && iter.hasNext()) {
            this.currentIter.put(e, iter);
        }
        if (iter == null || !iter.hasNext()) {
            this.debug(e, false);
            return this.actualNext;
        }
        this.current.put(e, iter.next());
        return this.walk(e, true);
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "loop " + this.expr.toString(e, debug);
    }

    public Object getCurrent(Event e) {
        return this.current.get(e);
    }

    public Expression<?> getLoopedExpression() {
        return this.expr;
    }

    @Override
    public void setNext(TriggerItem next) {
        this.actualNext = next;
    }

    public TriggerItem getActualNext() {
        return this.actualNext;
    }
}

