/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import org.bukkit.event.Event;

public class Conditional
extends TriggerSection {
    private final Condition cond;
    private TriggerSection elseClause = null;

    public Conditional(Condition cond, SectionNode node) {
        super(node);
        this.cond = cond;
    }

    @Override
    protected TriggerItem walk(Event e) {
        if (this.cond.run(e)) {
            return this.walk(e, true);
        }
        this.debug(e, false);
        if (this.elseClause != null) {
            return this.elseClause;
        }
        return this.getNext();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return this.cond.toString(e, debug);
    }

    public void loadElseClause(SectionNode node) {
        this.elseClause = new TriggerSection(node){

            @Override
            public TriggerItem walk(Event e) {
                this.debug(e, false);
                return this.getNext();
            }

            @Override
            public String toString(Event e, boolean debug) {
                return "else";
            }
        };
        this.elseClause.setParent(this.getParent());
        this.elseClause.setNext(this.getNext());
        this.setNext(this.elseClause);
    }
}

