/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class ExprDistance
extends SimpleExpression<Double> {
    private Expression<Location> loc1;
    private Expression<Location> loc2;

    static {
        Skript.registerExpression(ExprDistance.class, Double.class, Skript.ExpressionType.COMBINED, "[the] distance between %location% and %location%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.loc1 = vars[0];
        this.loc2 = vars[1];
        return true;
    }

    protected Double[] get(Event e) {
        Location l1 = this.loc1.getSingle(e);
        Location l2 = this.loc2.getSingle(e);
        if (l1 == null || l2 == null || l1.getWorld() != l2.getWorld()) {
            return null;
        }
        return new Double[]{l1.distance(l2)};
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "distance between " + this.loc1.toString(e, debug) + " and " + this.loc2.toString(e, debug);
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Double> getReturnType() {
        return Double.class;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

