/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Utils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;

public class ExprAttacker
extends SimpleExpression<Entity> {
    static {
        Skript.registerExpression(ExprAttacker.class, Entity.class, Skript.ExpressionType.SIMPLE, "[the] (attacker|damager)");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        return true;
    }

    protected Entity[] get(Event e) {
        return new Entity[]{Utils.validate(ExprAttacker.getAttacker(e))};
    }

    private static Entity getAttacker(Event e) {
        if (e instanceof EntityDamageByEntityEvent) {
            if (((EntityDamageByEntityEvent)e).getDamager() instanceof Projectile) {
                return ((Projectile)((EntityDamageByEntityEvent)e).getDamager()).getShooter();
            }
            return ((EntityDamageByEntityEvent)e).getDamager();
        }
        if (e instanceof EntityDeathEvent) {
            return ExprAttacker.getAttacker((Event)((EntityDeathEvent)e).getEntity().getLastDamageCause());
        }
        if (e instanceof VehicleDamageEvent) {
            return ((VehicleDamageEvent)e).getAttacker();
        }
        if (e instanceof VehicleDestroyEvent) {
            return ((VehicleDestroyEvent)e).getAttacker();
        }
        return null;
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the attacker";
        }
        return Skript.getDebugMessage(this.getSingle(e));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

