/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Utils;
import java.lang.reflect.Array;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEvent;

public class ExprAttacked
extends SimpleExpression<Entity> {
    private EntityData<?> type;
    private Entity[] one;

    static {
        Skript.registerExpression(ExprAttacked.class, Entity.class, Skript.ExpressionType.SIMPLE, "[the] (attacked|damaged|victim) [<(.+)>]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, int isDelayed, SkriptParser.ParseResult parser) {
        String type;
        if (!Utils.containsAny(ScriptLoader.currentEvents, EntityDamageEvent.class, EntityDamageByBlockEvent.class, EntityDamageByEntityEvent.class, EntityDeathEvent.class)) {
            Skript.error("Cannot use 'damaged'/'victim' outside of a damage or death event");
            return false;
        }
        String string = type = parser.regexes.size() == 0 ? null : parser.regexes.get(0).group();
        if (type == null) {
            this.type = EntityData.fromClass(Entity.class);
        } else {
            this.type = EntityData.parse(type);
            if (this.type == null) {
                Skript.error("'" + type + "' is not an entity type");
                return false;
            }
        }
        this.one = (Entity[])Array.newInstance(this.type.getType(), 1);
        return true;
    }

    protected Entity[] get(Event e) {
        Entity entity = Utils.validate(((EntityEvent)e).getEntity());
        if (this.type.isInstance(entity)) {
            this.one[0] = entity;
            return this.one;
        }
        return null;
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.type.getType();
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the attacked " + this.type;
        }
        return Skript.getDebugMessage(this.getSingle(e));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

