/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import org.bukkit.entity.Enderman;

public class EndermanData
extends EntityData<Enderman> {
    private Literal<ItemType> hand = null;
    private boolean plural;

    static {
        EntityData.register(EndermanData.class, "enderman", Enderman.class, "enderm(a|e)n [(carrying|holding) %-itemtypes%]");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.hand = exprs[0];
        this.plural = parseResult.expr.startsWith("endermen");
        return true;
    }

    @Override
    public void set(Enderman entity) {
        if (this.hand != null) {
            entity.setCarriedMaterial(this.hand.getSingle().getBlock().getRandom().getData());
        }
    }

    @Override
    public boolean match(final Enderman entity) {
        return this.hand == null || this.hand.check(null, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                return t.isOfType(entity.getCarriedMaterial().getItemTypeId(), entity.getCarriedMaterial().getData());
            }
        });
    }

    @Override
    public Class<Enderman> getType() {
        return Enderman.class;
    }

    @Override
    public String toString() {
        return "enderman carrying " + this.hand;
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }
}

