/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions.base;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import org.bukkit.event.Event;

public abstract class PropertyCondition<T>
extends Condition {
    private final Checker<? super T> checker;
    private Expression<? extends T> expr;
    private final String property;

    public PropertyCondition(String property, Checker<? super T> checker) {
        this.property = property;
        this.checker = checker;
    }

    protected static void register(Class<? extends PropertyCondition<?>> c, String property, String type) {
        Skript.registerCondition(c, "%" + type + "% (is|are) " + property, "%" + type + "% (isn't|is not|aren't|are not) " + property);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, int isDelayed, SkriptParser.ParseResult parseResult) {
        this.expr = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.expr.check(e, this.checker, this);
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.expr.toString(e, debug)) + (this.expr.isSingle() ? " is " : " are ") + (this.isNegated() ? "not " : "") + this.property;
    }
}

