/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.classes.Converter;
import ch.njol.util.Validate;

public final class ChainedConverter<F, M, T>
implements Converter<F, T> {
    private final Converter<? super F, ? extends M> first;
    private final Converter<? super M, ? extends T> second;

    public ChainedConverter(Converter<? super F, ? extends M> first, Converter<? super M, ? extends T> second) {
        Validate.notNull(first, second);
        this.first = first;
        this.second = second;
    }

    public static final <F, M, T> ChainedConverter<F, M, T> newInstance(Converter<? super F, ?> first, Converter<?, ? extends T> second) {
        return new ChainedConverter(first, second);
    }

    @Override
    public T convert(F f) {
        M m = this.first.convert(f);
        if (m == null) {
            return null;
        }
        return this.second.convert(m);
    }
}

