/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Aliases;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.SkriptLogger;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.command.Commands;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Conditional;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Callback;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class ScriptLoader {
    public static Config currentScript = null;
    public static SkriptEvent currentEvent = null;
    public static Class<? extends Event>[] currentEvents = null;
    public static List<TriggerSection> currentSections = new ArrayList<TriggerSection>();
    public static List<Loop> currentLoops = new ArrayList<Loop>();
    public static final Map<String, ItemType> currentAliases = new HashMap<String, ItemType>();
    public static final HashMap<String, String> currentOptions = new HashMap();
    public static int hasDelayBefore = -1;
    private static String indentation = "";
    static final List<Trigger> selfRegisteredTriggers = new ArrayList<Trigger>();
    private static final Set<Class<? extends Event>> registeredEvents = new HashSet<Class<? extends Event>>();

    private ScriptLoader() {
    }

    static ScriptInfo loadScripts() {
        File scriptsFolder = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separatorChar);
        File oldFolder = new File(Skript.getInstance().getDataFolder(), "triggers" + File.separatorChar);
        if (oldFolder.isDirectory()) {
            if (!scriptsFolder.isDirectory()) {
                oldFolder.renameTo(scriptsFolder);
                Skript.info("[1.3] Renamed your 'triggers' folder to 'scripts' to match the new format");
            } else {
                Skript.error("Found both a 'triggers' and a 'scripts' folder, ignoring the 'triggers' folder");
            }
        }
        if (!scriptsFolder.isDirectory()) {
            scriptsFolder.mkdirs();
        }
        int renamed = 0;
        File[] fileArray = scriptsFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".cfg");
            }
        });
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String name = f.getName().substring(0, f.getName().length() - ".cfg".length());
            File n3 = new File(scriptsFolder, String.valueOf(name) + ".sk");
            if (!n3.exists()) {
                f.renameTo(n3);
                ++renamed;
            } else {
                Skript.error("Found both an old and a new script named '" + name + "', ignoring the old one");
            }
            ++n2;
        }
        if (renamed > 0) {
            Skript.info("[1.3] Renamed " + renamed + " scripts to match the new format");
        }
        SkriptLogger.SubLog log = SkriptLogger.startSubLog();
        Date start = new Date();
        ScriptInfo i = ScriptLoader.loadScripts(scriptsFolder);
        log.stop();
        log.printLog();
        if (!log.hasErrors()) {
            Skript.info("All scripts loaded without errors!");
        }
        if (i.files == 0) {
            Skript.warning("No scripts were found, maybe you should write some ;)");
        }
        if (Skript.logNormal() && i.files > 0) {
            Skript.info("loaded " + i.files + " script" + (i.files == 1 ? "" : "s") + " with a total of " + i.triggers + " trigger" + (i.triggers == 1 ? "" : "s") + " and " + i.commands + " command" + (i.commands == 1 ? "" : "s") + " in " + start.difference(new Date()));
        }
        ScriptLoader.registerBukkitEvents();
        return i;
    }

    private static final ScriptInfo loadScripts(File directory) {
        ScriptInfo i = new ScriptInfo();
        File[] fileArray = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return (f.isDirectory() || f.getName().endsWith(".sk")) && !f.getName().startsWith("-");
            }
        });
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                i.add(ScriptLoader.loadScripts(f));
            } else {
                i.add(ScriptLoader.loadScript(f));
            }
            ++n2;
        }
        return i;
    }

    public static final ScriptInfo loadScripts(Collection<File> files) {
        ScriptInfo i = new ScriptInfo();
        for (File f : files) {
            i.add(ScriptLoader.loadScript(f));
        }
        ScriptLoader.registerBukkitEvents();
        return i;
    }

    static final ScriptInfo loadScript(File f) {
        try {
            Config c = new Config(f, true, false, ":");
            if (Skript.keepConfigsLoaded) {
                Skript.configs.add(c);
            }
            ScriptInfo scriptInfo = ScriptLoader.loadScript(c);
            return scriptInfo;
        }
        catch (IOException e) {
            Skript.error("Could not load " + f.getName() + ": " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            Skript.exception(e, "Could not load " + f.getName());
        }
        finally {
            SkriptLogger.setNode(null);
        }
        return new ScriptInfo();
    }

    private static final void registerBukkitEvents() {
        for (Class<? extends Event> e : SkriptEventHandler.triggers.keySet()) {
            if (registeredEvents.contains(e)) continue;
            Bukkit.getPluginManager().registerEvent(e, new Listener(){}, Skript.priority, SkriptEventHandler.ee, (Plugin)Skript.getInstance());
            registeredEvents.add(e);
        }
    }

    static final ScriptInfo unloadScript(File script) {
        ScriptInfo info = new ScriptInfo();
        Iterator<List<Trigger>> triggersIter = SkriptEventHandler.triggers.values().iterator();
        while (triggersIter.hasNext()) {
            List<Trigger> ts = triggersIter.next();
            int i = 0;
            while (i < ts.size()) {
                if (ts.get(i).getScript().equals(script)) {
                    ++info.triggers;
                    ts.remove(i);
                    --i;
                    if (ts.isEmpty()) {
                        triggersIter.remove();
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < selfRegisteredTriggers.size()) {
            Trigger t = selfRegisteredTriggers.get(i);
            if (t.getScript().equals(script)) {
                ++info.triggers;
                t.getEvent().unregister(t);
                selfRegisteredTriggers.remove(i);
                --i;
            }
            ++i;
        }
        info.commands = Commands.unregisterCommands(script);
        return info;
    }

    private static final String replaceOptions(String s) {
        return StringUtils.replaceAll(s, "\\{@(.+?)\\}", new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                String option = currentOptions.get(m.group(1));
                if (option == null) {
                    Skript.error("undefined option " + m.group());
                    return null;
                }
                return option;
            }
        });
    }

    public static ArrayList<TriggerItem> loadItems(SectionNode node) {
        if (Skript.debug()) {
            indentation = String.valueOf(indentation) + "    ";
        }
        ArrayList<TriggerItem> items = new ArrayList<TriggerItem>();
        int hadDelayBeforeLastIf = -1;
        for (Node n : node) {
            int hadDelayBefore;
            Condition cond;
            SkriptLogger.setNode(n);
            if (n instanceof SimpleNode) {
                Statement stmt;
                SimpleNode e = (SimpleNode)n;
                String ex = ScriptLoader.replaceOptions(e.getName());
                if (ex == null || (stmt = Statement.parse(ex, "can't understand this condition/effect: '" + ex + "'")) == null) continue;
                if (Skript.debug()) {
                    Skript.info(String.valueOf(indentation) + stmt.toString(null, true));
                }
                items.add(stmt);
                if (!(stmt instanceof Delay)) continue;
                hasDelayBefore = 1;
                continue;
            }
            if (!(n instanceof SectionNode)) continue;
            if (StringUtils.startsWithIgnoreCase(n.getName(), "loop ")) {
                Expression loopedExpr;
                String l = ScriptLoader.replaceOptions(n.getName().substring("loop ".length()));
                if (l == null || (loopedExpr = (Expression)SkriptParser.parse(l, Skript.getExpressions().iterator(), false, false, "can't understand this expression: '" + n.getName() + "'")) == null) continue;
                if (!loopedExpr.canLoop()) {
                    Skript.error("Can't loop " + loopedExpr);
                    continue;
                }
                if (Skript.debug()) {
                    Skript.info(String.valueOf(indentation) + "loop " + loopedExpr.toString(null, true) + ":");
                }
                int hadDelayBefore2 = hasDelayBefore;
                items.add(new Loop(loopedExpr, (SectionNode)n));
                if (hadDelayBefore2 == 1 || hasDelayBefore == -1) continue;
                hasDelayBefore = 0;
                continue;
            }
            if (n.getName().equalsIgnoreCase("else")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional)) {
                    Skript.error("'else' has to be placed just after the end of a conditional section");
                    continue;
                }
                if (Skript.debug()) {
                    Skript.info(String.valueOf(indentation) + "else:");
                }
                int hadDelayAfterLastIf = hasDelayBefore;
                hasDelayBefore = hadDelayBeforeLastIf;
                ((Conditional)items.get(items.size() - 1)).loadElseClause((SectionNode)n);
                if (hadDelayBeforeLastIf == 1) {
                    hasDelayBefore = 1;
                    continue;
                }
                if (hadDelayBeforeLastIf == -1 && hadDelayAfterLastIf == -1 && hasDelayBefore == -1) {
                    hasDelayBefore = -1;
                    continue;
                }
                if (hadDelayAfterLastIf == 1 && hasDelayBefore == 1) {
                    hasDelayBefore = 1;
                    continue;
                }
                if (hadDelayAfterLastIf == -1 && hasDelayBefore == -1) continue;
                hasDelayBefore = 0;
                continue;
            }
            String name = n.getName();
            if (name.startsWith("if ")) {
                name = name.substring(3);
            }
            if ((cond = Condition.parse(name, "can't understand this condition: '" + name + "'")) == null) continue;
            if (Skript.debug()) {
                Skript.info(String.valueOf(indentation) + cond.toString(null, true) + ":");
            }
            hadDelayBeforeLastIf = hadDelayBefore = hasDelayBefore;
            items.add(new Conditional(cond, (SectionNode)n));
            if (hadDelayBefore == 1 || hasDelayBefore == -1) continue;
            hasDelayBefore = 0;
        }
        int i = 0;
        while (i < items.size() - 1) {
            ((TriggerItem)items.get(i)).setNext(items.get(i + 1));
            ++i;
        }
        SkriptLogger.setNode(node);
        if (Skript.debug()) {
            indentation = indentation.substring(0, indentation.length() - 4);
        }
        return items;
    }

    private static ScriptInfo loadScript(Config config) {
        int numTriggers = 0;
        int numCommands = 0;
        currentAliases.clear();
        currentOptions.clear();
        currentScript = config;
        for (Node cnode : config.getMainNode()) {
            Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parsedEvent;
            if (!(cnode instanceof SectionNode)) {
                Skript.error("invalid line - all code has to be put into triggers");
                continue;
            }
            SectionNode node = (SectionNode)cnode;
            String event = node.getName();
            if (event.equalsIgnoreCase("aliases")) {
                node.convertToEntries(0, "=");
                for (Node n : node) {
                    if (!(n instanceof EntryNode)) {
                        Skript.error("invalid line in alias section");
                        continue;
                    }
                    ItemType t = Aliases.parseAlias(((EntryNode)n).getValue());
                    if (t == null) continue;
                    currentAliases.put(((EntryNode)n).getKey().toLowerCase(), t);
                }
                continue;
            }
            if (event.equalsIgnoreCase("options")) {
                node.convertToEntries(0);
                for (Node n : node) {
                    if (!(n instanceof EntryNode)) {
                        Skript.error("invalid line in options");
                        continue;
                    }
                    currentOptions.put(((EntryNode)n).getKey(), ((EntryNode)n).getValue());
                }
                continue;
            }
            if (event.equalsIgnoreCase("variables")) {
                node.convertToEntries(0, "=");
                for (Node n : node) {
                    String var;
                    if (!(n instanceof EntryNode)) {
                        Skript.error("invalid line in variables");
                        continue;
                    }
                    String name = ((EntryNode)n).getKey();
                    if (name.startsWith("{") && name.endsWith("}")) {
                        name = name.substring(1, name.length() - 1);
                    }
                    if ((name = StringUtils.replaceAll(name, "%(.+)?%", new Callback<String, Matcher>(var = name){
                        private final /* synthetic */ String val$var;
                        {
                            this.val$var = string;
                        }

                        @Override
                        public String run(Matcher m) {
                            if (m.group(1).contains("{") || m.group(1).contains("}") || m.group(1).contains("%")) {
                                Skript.error("'" + this.val$var + "' is not a valid name for a default variable");
                                return null;
                            }
                            ClassInfo<?> ci = Skript.getClassInfoFromUserInput(m.group(1));
                            if (ci == null) {
                                Skript.error("Can't understand the type '" + m.group(1) + "'");
                                return null;
                            }
                            return "<" + ci.getCodeName() + ">";
                        }
                    })) == null || name.contains("%") || Skript.getVariable(name) != null) continue;
                    SkriptLogger.SubLog log = SkriptLogger.startSubLog();
                    Object o = Skript.parseSimple(((EntryNode)n).getValue(), Object.class, ParseContext.CONFIG);
                    SkriptLogger.stopSubLog(log);
                    if (o == null) {
                        log.printErrors("Can't understand the value '" + ((EntryNode)n).getValue() + "'");
                        continue;
                    }
                    ClassInfo<?> ci = Skript.getSuperClassInfo(o.getClass());
                    if (ci.getSerializeAs() != null) {
                        ClassInfo<?> as = Skript.getSuperClassInfo(ci.getSerializeAs());
                        if (as == null) {
                            Skript.exception("Missing class info for " + ci.getSerializeAs().getName() + ", the class to serialize " + ci.getC().getName() + " as");
                            continue;
                        }
                        if ((o = Skript.convert(o, as.getC())) == null) {
                            Skript.error("Can't save '" + ((EntryNode)n).getValue() + "' in a variable");
                            continue;
                        }
                    }
                    Skript.setVariable(name, o);
                }
                continue;
            }
            if (StringUtils.count(event, '\"') % 2 != 0) {
                Skript.error("Invalid use of quotes (\"). If you want to use quotes in \"quoted text\", double them: \"\".");
                continue;
            }
            if (event.toLowerCase().startsWith("command ")) {
                currentEvent = null;
                currentEvents = Skript.array(CommandEvent.class);
                if (Commands.loadCommand(node) == null) continue;
                ++numCommands;
                continue;
            }
            if (Skript.logVeryHigh() && !Skript.debug()) {
                Skript.info("loading trigger '" + event + "'");
            }
            if (event.toLowerCase().startsWith("on ")) {
                event = event.substring("on ".length());
            }
            if ((event = ScriptLoader.replaceOptions(event)) == null || (parsedEvent = SkriptParser.parseEvent(event, "can't understand this event: '" + node.getName() + "'")) == null) continue;
            if (Skript.debug()) {
                Skript.info(String.valueOf(event) + " (" + ((SkriptEvent)parsedEvent.second).toString(null, true) + "):");
            }
            currentEvent = (SkriptEvent)parsedEvent.second;
            currentEvents = ((SkriptEvent.SkriptEventInfo)parsedEvent.first).events;
            hasDelayBefore = -1;
            Trigger trigger = new Trigger(config.getFile(), event, (SkriptEvent)parsedEvent.second, ScriptLoader.loadItems(node));
            currentEvent = null;
            currentEvents = null;
            hasDelayBefore = -1;
            if (((SkriptEvent.SkriptEventInfo)parsedEvent.first).fire) {
                SkriptEventHandler.addTrigger(((SkriptEvent.SkriptEventInfo)parsedEvent.first).events, trigger);
            } else {
                ((SkriptEvent)parsedEvent.second).register(trigger);
                selfRegisteredTriggers.add(trigger);
            }
            ++numTriggers;
        }
        if (Skript.logHigh()) {
            Skript.info("loaded " + numTriggers + " trigger" + (numTriggers == 1 ? "" : "s") + " and " + numCommands + " command" + (numCommands == 1 ? "" : "s") + " from '" + config.getFileName() + "'");
        }
        currentScript = null;
        return new ScriptInfo(1, numTriggers, numCommands);
    }

    static Trigger loadTrigger(SectionNode node) {
        String event = node.getName();
        if (event.toLowerCase().startsWith("on ")) {
            event = event.substring("on ".length());
        }
        Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parsedEvent = SkriptParser.parseEvent(event, "can't understand this event: '" + node.getName() + "'");
        currentEvent = (SkriptEvent)parsedEvent.second;
        currentEvents = ((SkriptEvent.SkriptEventInfo)parsedEvent.first).events;
        Trigger t = new Trigger(null, event, (SkriptEvent)parsedEvent.second, ScriptLoader.loadItems(node));
        currentEvent = null;
        currentEvents = null;
        return t;
    }

    public static final class ScriptInfo {
        public int files;
        public int triggers;
        public int commands;

        public ScriptInfo() {
        }

        public ScriptInfo(int numFiles, int numTriggers, int numCommands) {
            this.files = numFiles;
            this.triggers = numTriggers;
            this.commands = numCommands;
        }

        public void add(ScriptInfo other) {
            this.files += other.files;
            this.triggers += other.triggers;
            this.commands += other.commands;
        }
    }
}

