/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;

public class Language {
    private static String name = "english";
    private static Properties defaults = new Properties();
    private static Properties strings = new Properties(defaults);
    private static final Collection<LanguageChangeListener> listeners = new HashSet<LanguageChangeListener>();

    public static String getName() {
        return name;
    }

    public static String get(String key) {
        return strings.getProperty(key.toLowerCase());
    }

    public static String getDefault(String key) {
        return defaults.getProperty(key.toLowerCase());
    }

    public static String format(String key, Object ... args) {
        return String.format(Language.get(key), args);
    }

    public static String getSpaced(String key) {
        String s = strings.getProperty(key.toLowerCase());
        if (s.isEmpty()) {
            return " ";
        }
        return " " + s + " ";
    }

    static void loadDefault() {
        InputStream din = Skript.getInstance().getResource("lang/english.lang");
        if (din == null) {
            throw new IllegalStateException("Skript.jar is missing the required english.lang file!");
        }
        try {
            defaults.load(new InputStreamReader(din, "UTF-8"));
        }
        catch (IOException e) {
            throw Skript.exception(e, "Could not load the default language file!");
        }
        for (LanguageChangeListener l : listeners) {
            l.onLanguageChange();
        }
    }

    static boolean load(String name) {
        InputStream in = Skript.getInstance().getResource("lang/" + name + ".lang");
        if (in == null) {
            return false;
        }
        try {
            strings.load(new InputStreamReader(in, "UTF-8"));
        }
        catch (IOException e) {
            throw Skript.exception(e, "Could not load the language file!");
        }
        Language.name = name;
        for (LanguageChangeListener l : listeners) {
            l.onLanguageChange();
        }
        return true;
    }

    static void clear() {
        strings.clear();
    }

    public static void addListener(LanguageChangeListener l) {
        listeners.add(l);
        if (!defaults.isEmpty()) {
            l.onLanguageChange();
        }
    }

    public static void removeListener(LanguageChangeListener l) {
        listeners.remove(l);
    }

    public static interface LanguageChangeListener {
        public void onLanguageChange();
    }
}

