/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util.iterator;

import ch.njol.util.Validate;
import java.util.List;
import java.util.ListIterator;

public class ReversedListIterator<T>
implements ListIterator<T> {
    private final ListIterator<T> iter;

    public ReversedListIterator(List<T> list) {
        Validate.notNull(list, "list");
        this.iter = list.listIterator(list.size());
    }

    public ReversedListIterator(List<T> list, int index) {
        Validate.notNull(list, "list");
        this.iter = list.listIterator(list.size() - index);
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasPrevious();
    }

    @Override
    public T next() {
        return this.iter.previous();
    }

    @Override
    public boolean hasPrevious() {
        return this.iter.hasNext();
    }

    @Override
    public T previous() {
        return this.iter.next();
    }

    @Override
    public int nextIndex() {
        return this.iter.previousIndex();
    }

    @Override
    public int previousIndex() {
        return this.iter.nextIndex();
    }

    @Override
    public void remove() {
        this.iter.remove();
    }

    @Override
    public void set(T e) {
        this.iter.set(e);
    }

    @Override
    public void add(T e) {
        throw new UnsupportedOperationException();
    }
}

