/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class Offset {
    private final double[] mod;
    private final boolean isOffset;
    private static final Pattern offsetPattern = Pattern.compile("( (\\d+(\\.\\d+)?( (block|meter)s?)? )?((to the )?((south|north)(-?(east|west))?|east|west)(ward(s|ly)?|er(n|ly))?( of)?|above|over|below|under(neath)?|beneath))+");

    public Offset(double modX, double modY, double modZ) {
        this.mod = new double[]{modX, modY, modZ};
        this.isOffset = modX != 0.0 || modY != 0.0 || modZ != 0.0;
    }

    public Offset(double[] mod) {
        if (mod == null || mod.length != 3) {
            throw new IllegalArgumentException();
        }
        this.mod = mod;
        this.isOffset = mod[0] != 0.0 || mod[1] != 0.0 || mod[2] != 0.0;
    }

    public Block getRelative(Block block) {
        if (block == null || !this.isOffset) {
            return block;
        }
        return block.getRelative((int)Math.round(this.mod[0]), (int)Math.round(this.mod[1]), (int)Math.round(this.mod[2]));
    }

    public Location getRelative(Location location) {
        if (location == null) {
            return null;
        }
        if (!this.isOffset) {
            return location.clone();
        }
        return location.clone().add(this.mod[0], this.mod[1], this.mod[2]);
    }

    public Location setOff(Location location) {
        if (location == null || !this.isOffset) {
            return location;
        }
        return location.add(this.mod[0], this.mod[1], this.mod[2]);
    }

    public static Location[] setOff(Offset[] offsets, Location[] locations) {
        Location[] off = new Location[locations.length * offsets.length];
        int i = 0;
        while (i < locations.length) {
            if (locations[i] == null) {
                throw new IllegalArgumentException("There must be no null elements in the locations array");
            }
            int j = 0;
            while (j < offsets.length) {
                off[offsets.length * i + j] = offsets[j].getRelative(locations[i]);
                ++j;
            }
            ++i;
        }
        return off;
    }

    public static Block[] setOff(Offset[] offsets, Block[] blocks) {
        Block[] off = new Block[blocks.length * offsets.length];
        int i = 0;
        while (i < blocks.length) {
            if (blocks[i] == null) {
                throw new IllegalArgumentException("There must be no null elements in the blocks array");
            }
            int j = 0;
            while (j < offsets.length) {
                off[offsets.length * i + j] = offsets[j].getRelative(blocks[i]);
                ++j;
            }
            ++i;
        }
        return off;
    }

    public boolean isOffset() {
        return this.isOffset;
    }

    public String toString() {
        if (!this.isOffset) {
            return "at";
        }
        StringBuilder r = new StringBuilder();
        boolean printNumbers = false;
        int i = 0;
        while (i < 3) {
            if (this.mod[i] != 0.0 && this.mod[i] != 1.0 && this.mod[i] != -1.0) {
                printNumbers = true;
            }
            ++i;
        }
        BlockFace[] dirs = new BlockFace[]{BlockFace.SOUTH, BlockFace.UP, BlockFace.WEST};
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 1;
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i2 = nArray2[n2];
            if (this.mod[i2] != 0.0) {
                if (this.mod[i2] * (double)Utils.getBlockFaceDir(dirs[i2], i2) > 0.0) {
                    r.append(String.valueOf(r.length() == 0 ? "" : " ") + (printNumbers ? String.valueOf(StringUtils.toString(this.mod[i2], 2)) + " " : "") + Offset.getFaceName(dirs[i2]));
                } else {
                    r.append(String.valueOf(r.length() == 0 ? "" : " ") + (printNumbers ? String.valueOf(StringUtils.toString(-this.mod[i2], 2)) + " " : "") + Offset.getFaceName(dirs[i2].getOppositeFace()));
                }
            }
            ++n2;
        }
        return r.toString();
    }

    private static String getFaceName(BlockFace face) {
        switch (face) {
            case DOWN: {
                return "below";
            }
            case UP: {
                return "above";
            }
            case NORTH: 
            case EAST: 
            case SOUTH: 
            case WEST: {
                return face.toString().toLowerCase();
            }
        }
        throw new IllegalArgumentException();
    }

    public int hashCode() {
        return Arrays.hashCode(this.mod);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Offset)) {
            return false;
        }
        Offset other = (Offset)obj;
        if (!this.isOffset && !other.isOffset) {
            return true;
        }
        return Arrays.equals(this.mod, other.mod);
    }

    public static Offset combine(Offset[] offsets) {
        if (offsets == null || offsets.length == 0) {
            return null;
        }
        if (offsets.length == 1) {
            return offsets[0];
        }
        double[] mod = new double[3];
        Offset[] offsetArray = offsets;
        int n = offsets.length;
        int n2 = 0;
        while (n2 < n) {
            Offset o = offsetArray[n2];
            int axis = 0;
            while (axis < 3) {
                int n3 = axis;
                mod[n3] = mod[n3] + o.mod[axis];
                ++axis;
            }
            ++n2;
        }
        return new Offset(mod);
    }

    private static final BlockFace scanForFace(String s, int i) {
        if (s.startsWith("east", i)) {
            return BlockFace.EAST;
        }
        if (s.startsWith("west", i)) {
            return BlockFace.WEST;
        }
        if (s.startsWith("south", i)) {
            if (s.startsWith("east", i + 5) || s.startsWith("east", i + 6)) {
                return BlockFace.SOUTH_EAST;
            }
            if (s.startsWith("west", i + 5) || s.startsWith("west", i + 6)) {
                return BlockFace.SOUTH_WEST;
            }
            return BlockFace.SOUTH;
        }
        if (s.startsWith("north", i)) {
            if (s.startsWith("east", i + 5) || s.startsWith("east", i + 6)) {
                return BlockFace.NORTH_EAST;
            }
            if (s.startsWith("west", i + 5) || s.startsWith("west", i + 6)) {
                return BlockFace.NORTH_WEST;
            }
            return BlockFace.NORTH;
        }
        if (s.startsWith("above", i) || s.startsWith("over", i)) {
            return BlockFace.UP;
        }
        if (s.startsWith("below", i) || s.startsWith("under", i) || s.startsWith("beneath", i)) {
            return BlockFace.DOWN;
        }
        return null;
    }

    public static Offset parse(String s) {
        Matcher m;
        if (s.isEmpty()) {
            return null;
        }
        String lower = s.toLowerCase();
        if (lower.equals("at")) {
            return new Offset(0.0, 0.0, 0.0);
        }
        if (lower.startsWith("at ")) {
            lower = lower.substring(3);
        }
        if (!(m = offsetPattern.matcher(" " + lower)).matches()) {
            return null;
        }
        double[] mod = new double[3];
        double amount = 1.0;
        int i = 0;
        while (i < lower.length()) {
            BlockFace f;
            if ('0' <= lower.charAt(i) && lower.charAt(i) <= '9') {
                int i2 = lower.indexOf(32, i + 1);
                amount = Double.parseDouble(lower.substring(i, i2));
                i = i2 + 1;
            }
            if ((f = Offset.scanForFace(lower, i)) != null) {
                i += f.name().length();
                mod[0] = mod[0] + amount * (double)f.getModX();
                mod[1] = mod[1] + amount * (double)f.getModY();
                mod[2] = mod[2] + amount * (double)f.getModZ();
                amount = 1.0;
            }
            ++i;
        }
        return new Offset(mod);
    }

    public Vector toVector() {
        return new Vector(this.mod[0], this.mod[1], this.mod[2]);
    }
}

